package com.ejie.p06b.dao.solreclamacion;

import java.io.StringReader;
import java.math.BigDecimal;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;

import com.ejie.p06b.log.P06BLog;

import com.ejie.p06b.dao.P06bDao;
import com.ejie.p06b.dao.P06B23T00DAO;
import com.ejie.p06b.datatype.model.P06B22T00Datatype;
import com.ejie.p06b.datatype.model.P06B23T00Datatype;
import com.ejie.p06b.datatype.model.P06B24T00Datatype;
import com.ejie.p06b.datatype.model.P06B60T00Datatype;
import com.ejie.p06b.datatype.model.P06B61T00Datatype;
import com.ejie.p06b.datatype.model.P06B64T00Datatype;
import com.ejie.p06b.datatype.model.P06B81T00Datatype;
import com.ejie.p06b.datatype.model.P06B82T00Datatype;
import com.ejie.p06b.exception.P06BModMediadorException;
import com.ejie.p06b.general.P06BConstantes;
import com.ejie.p06b.manager.P06bMng;
//import com.ejie.p06b.manager.contextSubmissionEvent.ContextSubmissionEvent;
import com.ejie.aa87b.manager.contextSubmissionEvent.ContextSubmissionEvent;
import com.ejie.p06b.manager.ejgvDocument.Attachment;
import com.ejie.p06b.manager.ejgvDocument.EjgvDocument;
import com.ejie.p06b.manager.ejgvDocument.Language;
import com.ejie.p06b.model.DatosMediadores;
import com.ejie.p06b.general.P06BTablas;

public class P06bAltaMediadoresDao extends P06bDao {
	
	/**
	 * Constructor por defecto
	 */
	public P06bAltaMediadoresDao() {
		this.con = null;
		this.stmt = null;
		this.rs = null;
		this.autoCommit = false;

	}

	/**
	 * Constructor a partir de un objeto Connection
	 * 
	 * @param con
	 *            : Objeto de tipo Connection con la conexin a base de datos
	 */
	public P06bAltaMediadoresDao(Connection con) {
		this.con = con;
		this.stmt = null;
		this.rs = null;
		this.autoCommit = false;
	}
	
	/**
	 * Inserto la solicitud de reclamacin
	 * 
	 * @param solicitud
	 *            : Objeto de tipo AltaMediadores con los datos de negocio de la solicitud de reclamacin
	 *				a almacenar en base de datos
	 *: Array de ficheros adjuntados
	 *:Array de extension de ficheros adjuntados
	 * @throws Exception
	 *             : Lanza un objeto de tipo Exception en caso de haber existido
	 *             algn problema
	 */
	public void insertarAltaMediador(DatosMediadores datosAltaMediador, P06B64T00Datatype p06B64T00Datatype, EjgvDocument ejgvDoc, ContextSubmissionEvent cData) throws SQLException {

		try {

			stmt = con.createStatement();
			
			this.getAlta21SQL(datosAltaMediador);
			P06BLog.send(0,P06bMng.class, "(insertarAltaMediador) Alta en tabla P06B21T00_EXPEDIENTES. Consulta a ejecutar: " + this.sql);
			stmt.executeUpdate(this.sql);

//			this.getAlta20SQL(datosAltaMediador, p06B64T00Datatype);
//			stmt.executeUpdate(this.sql);
			pstmt = this.prepareAlta20SQL(datosAltaMediador, p06B64T00Datatype);
			P06BLog.send(0,P06bMng.class, "(insertarAltaMediador) Alta en tabla P06B20T00_CORREDORES. Consulta a ejecutar: " + pstmt.toString());
			pstmt.executeUpdate();
			P06BLog.send(0,P06bMng.class, "(insertarAltaMediador) Alta en tabla P06B20T00_CORREDORES. Consulta a ejecutar: " + this.sql);

			String atencionCliente = datosAltaMediador.getaCTAtencioncliente();
			if (atencionCliente!=null){
				if (atencionCliente.equals(P06BConstantes.P06B_AC_CUENTACONSERVICIOENTRAMITAGUNE)){
					if (datosAltaMediador.getaCTId()!=null){
						if (!datosAltaMediador.getaCTId().trim().equals("")){
							//Datos atencin al cliente
							this.getAlta26SQL(datosAltaMediador);
							P06BLog.send(0,P06bMng.class, "(insertarAltaMediador) Alta en tabla P06B26T00_ATENCLIENTE. Consulta a ejecutar: "
									+ this.sql);
							stmt.executeUpdate(this.sql);						
						}
					}
					if (datosAltaMediador.getaCDId()!=null){
						if (!datosAltaMediador.getaCDId().trim().equals("")){
							//Datos defensor del cliente
							this.getAlta29SQL(datosAltaMediador);
							P06BLog.send(0,P06bMng.class, "(insertarAltaMediador) Alta en tabla P06B29T00_DEFECLIENTE. Consulta a ejecutar: "
									+ this.sql);
							stmt.executeUpdate(this.sql);						
						}
					}
				}				
			}
						
			List<P06B22T00Datatype> listP06B22T00Datatype = datosAltaMediador.getListP06B22T00Datatype();
			if (listP06B22T00Datatype!=null){
				int i=0;
				while (i<listP06B22T00Datatype.size()){
					pstmt = this.prepareAlta22SQL(listP06B22T00Datatype.get(i), cData);
					P06BLog.send(0,P06bMng.class, "(insertarAltaMediador) Alta en tabla P06B22T00_SOCIOSEXP. Consulta a ejecutar: "
							+ this.sql);
					pstmt.executeUpdate();
					i++;
				}				
			}						
			
			List<P06B24T00Datatype> listP06B24T00DatatypeOD = datosAltaMediador.getListP06B24T00DatatypeOD();
			if (listP06B24T00DatatypeOD!=null){
				int i=0;
				while (i<listP06B24T00DatatypeOD.size()){
					this.getAlta24ODSQL(listP06B24T00DatatypeOD.get(i), cData);
					P06BLog.send(0,P06bMng.class, "(insertarAltaMediador) Alta en tabla P06B24T00_ORGANOSDIREXP. Consulta a ejecutar: "
							+ this.sql);
					stmt.executeUpdate(this.sql);
					i++;
				}				
			}						
			

			List<P06B24T00Datatype> listP06B24T00DatatypeA = datosAltaMediador.getListP06B24T00DatatypeA();
			if (listP06B24T00DatatypeA!=null){
				int i=0;
				while (i<listP06B24T00DatatypeA.size()){
					this.getAlta24ASQL(listP06B24T00DatatypeA.get(i), cData);
					P06BLog.send(0,P06bMng.class, "(insertarAltaMediador) Alta en tabla P06B24T00_ORGANOSDIREXP. Consulta a ejecutar: "
							+ this.sql);
					stmt.executeUpdate(this.sql);
					i++;
				}				
			}						
			

			List<P06B61T00Datatype> listP06B61T00Datatype = datosAltaMediador.getListP06B61T00Datatype();
			if (listP06B61T00Datatype!=null){
				int i=0;
				while (i<listP06B61T00Datatype.size()){
					P06B61T00Datatype p06B61T00Datatype = listP06B61T00Datatype.get(i);
//					P06B23T00DAO p06B23T00DAO = new P06B23T00DAO();
//					P06B23T00Datatype p06B23T00Datatype = p06B23T00DAO.selectByCIF(p06B61T00Datatype.getCif());
//					if (p06B23T00Datatype!= null){
//						p06B61T00Datatype.setClavecat(p06B23T00Datatype.getClave());
//					}else{
//						p06B61T00Datatype.setClavecat("");
//					}
					this.getAlta61SQL(p06B61T00Datatype);
					P06BLog.send(0,P06bMng.class, "(insertarAltaMediador) Alta en tabla P06B61T00_ORGANOSDIREXP. Consulta a ejecutar: "
							+ this.sql);
					stmt.executeUpdate(this.sql);
					i++;
				}				
			}						
			
			if (datosAltaMediador.getcFDeclaro()!=0){
				this.getAlta60SQL(datosAltaMediador);
				P06BLog.send(0,P06bMng.class, "(insertarAltaMediador) Alta en tabla P06B26T00_ATENCLIENTE. Consulta a ejecutar: "
						+ this.sql);
				stmt.executeUpdate(this.sql);
			}

			//Obtener Documentacion adjunta
			List<P06B82T00Datatype> listaDocumentos = new ArrayList<P06B82T00Datatype>();
			if (ejgvDoc!=null && ejgvDoc.getAttachments()!=null){
				Integer contAttach=ejgvDoc.getAttachments().getAttachment().size();
				if (contAttach>0 ){
					for(int i=0;i<contAttach;i++){
						Attachment attachment = ejgvDoc.getAttachments().getAttachment().get(i);
						if (attachment.getID()!=null){
							P06B82T00Datatype documento = new P06B82T00Datatype();
							documento.setCorrelAtencPet(p06B64T00Datatype.getCorrelativo());
							documento.setRoleIdEnPid(attachment.getRoleId());
							List<Language> listaIdiomas = attachment.getRoleName().getDescription().getLanguage(); 
							int j=0;
							while (j<listaIdiomas.size()){
								if (listaIdiomas.get(j).getLocale().equals(P06BConstantes.P06B_IDIOMA_EU)){
									documento.setRoleNameEusEnPid(listaIdiomas.get(j).getValue());
								}else if (listaIdiomas.get(j).getLocale().equals(P06BConstantes.P06B_IDIOMA_ES)){
									documento.setRoleNameCasEnPid(listaIdiomas.get(j).getValue());
								}
								j++;
							}
							documento.setReferenciaEnPid(attachment.getID());
							String nombreFichero= attachment.getSourceName();
					        int indPunto = nombreFichero.lastIndexOf('.');
					        if (indPunto!=-1){
								documento.setNombreEnPid(nombreFichero.substring(0,indPunto));
								documento.setExtensionEnPid(nombreFichero.substring(indPunto+1));
					        }else{
								documento.setNombreEnPid(nombreFichero);
								documento.setExtensionEnPid(null);
					        }
					        listaDocumentos.add(documento);
						}
					}
				}
			}
			if(listaDocumentos.size()>0){
//				this.getInsertAdjuntosExpAltaSQL(datosAltaMediador, listaDocumentos);
				this.getInsertAdjuntosAPSQL(datosAltaMediador, p06B64T00Datatype, listaDocumentos);
				P06BLog.send(0,P06bMng.class, "(insertarAltaMediador) Alta de adjuntos. Consulta a ejecutar: " + this.sql);
				stmt.executeUpdate(this.sql);
				P06BLog.send(0,P06bMng.class, "(insertarAltaMediador)  Alta de adjuntos ejecutada correctamente");
			}

			
		// Exception occurred during commit of transaction
			// Reason=javax.transaction.xa.XAException: JDBC driver does not
			// support XA, hence cannot be a participant in two-phase commit
			// http://shantanu01.blogspot.com.es/2013/06/occurred-during-commit-of-transaction.html
			P06BLog.send(0,P06bMng.class, "(insertarAltaMediador) Completada");
			
		} catch (SQLException SQLe) {
			P06BLog.send(0,P06bMng.class, "(insertarAltaMediador) Error al ejecutar: " + this.sql);
			throw SQLe;
		} finally {
			if (rs != null) {
				rs.close();
			}
			if (stmt != null) {
				stmt.close();
			}
		}
	}
	
	
	/**
	 * Inserto la solicitud de reclamacin
	 * 
	 * @param solicitud
	 *            : Objeto de tipo AltaMediadores con los datos de negocio de la solicitud de reclamacin
	 *				a almacenar en base de datos
	 *: Array de ficheros adjuntados
	 *:Array de extension de ficheros adjuntados
	 * @throws Exception
	 *             : Lanza un objeto de tipo Exception en caso de haber existido
	 *             algn problema
	 */
	public void insertarModMediador(DatosMediadores datosModifMediador, P06B64T00Datatype p06B64T00Datatype, EjgvDocument ejgvDoc, ContextSubmissionEvent cData) throws SQLException {

		pstmt = this.prepareAlta70SQL(datosModifMediador, p06B64T00Datatype);
		pstmt.executeUpdate();
		P06BLog.send(0,P06bMng.class, "(insertarModMediador) Alta en tabla P06B70T00_CORREDORES. Consulta a ejecutar: "
				+ this.sql);

		if (datosModifMediador.isbActualizarAtencionDefensaCliente()){
			String atencionCliente = datosModifMediador.getaCTAtencioncliente();
			if (atencionCliente!=null){
				if (atencionCliente.equals(P06BConstantes.P06B_AC_CUENTACONSERVICIOENTRAMITAGUNE)){
					if (datosModifMediador.getaCTId()!=null){
						if (!datosModifMediador.getaCTId().trim().equals("")){
							//Datos atencin al cliente
							pstmt = this.prepareAlta76SQL(datosModifMediador, p06B64T00Datatype);
							P06BLog.send(0,P06bMng.class, "(insertarModMediador) Alta en tabla P06B76T00_ATENCLIENTE. Consulta a ejecutar: "
									+ this.sql);
							pstmt.executeUpdate();
						}
					}
					if (datosModifMediador.getaCDId()!=null){
						if (!datosModifMediador.getaCDId().trim().equals("")){
							//Datos defensor del cliente
							pstmt = this.prepareAlta79SQL(datosModifMediador, p06B64T00Datatype);
							P06BLog.send(0,P06bMng.class, "(insertarModMediador) Alta en tabla P06B79T00_DEFECLIENTE. Consulta a ejecutar: "
									+ this.sql);
							pstmt.executeUpdate();
						}
					}
				}
			}
		}
		
		if (datosModifMediador.isbActualizarCapitalSocial()){
			List<P06B22T00Datatype> listP06B22T00Datatype = datosModifMediador.getListP06B22T00Datatype();
			if (listP06B22T00Datatype!=null){
				int i=0;
				while (i<listP06B22T00Datatype.size()){
					pstmt = this.prepareAlta72SQL(listP06B22T00Datatype.get(i), p06B64T00Datatype, cData);
					P06BLog.send(0,P06bMng.class, "(insertarModMediador) Alta en tabla P06B72T00_SOCIOSEXP. Consulta a ejecutar: "
							+ this.sql);
					pstmt.executeUpdate();
					i++;
				}
			}
		}
		
		if (datosModifMediador.isbActualizarOrganoDireccion()){
			List<P06B24T00Datatype> listP06B24T00DatatypeOD = datosModifMediador.getListP06B24T00DatatypeOD();
			if (listP06B24T00DatatypeOD!=null){
				int i=0;
				while (i<listP06B24T00DatatypeOD.size()){
					pstmt = this.prepareAlta74AcreditacionParticipantesSQL(listP06B24T00DatatypeOD.get(i), p06B64T00Datatype, cData);
					P06BLog.send(0,P06bMng.class, "(insertarModMediador) Alta en tabla P06B74T00_ORGANOSDIREXP. Consulta a ejecutar: "
							+ this.sql);
					pstmt.executeUpdate();
					i++;
				}
			}
		}
		

		if (datosModifMediador.isbActualizarAdministradores()){
			List<P06B24T00Datatype> listP06B24T00DatatypeA = datosModifMediador.getListP06B24T00DatatypeA();
			if (listP06B24T00DatatypeA!=null){
				int i=0;
				while (i<listP06B24T00DatatypeA.size()){
					pstmt = this.prepareAlta74AcreditacionParticipantesSQL(listP06B24T00DatatypeA.get(i), p06B64T00Datatype, cData);
					P06BLog.send(0,P06bMng.class, "(insertarModMediador) Alta en tabla P06B74T00_ORGANOSDIREXP. Consulta a ejecutar: "
							+ this.sql);
					pstmt.executeUpdate();
					i++;
				}
			}
		}
		

		if (datosModifMediador.isbActualizarEntidadesVinculadas()){
			List<P06B61T00Datatype> listP06B61T00Datatype = datosModifMediador.getListP06B61T00Datatype();
			if (listP06B61T00Datatype!=null){
				int i=0;
				while (i<listP06B61T00Datatype.size()){
					P06B61T00Datatype p06B61T00Datatype = listP06B61T00Datatype.get(i);
					pstmt = this.prepareAlta71SQL(p06B61T00Datatype, p06B64T00Datatype);
					P06BLog.send(0,P06bMng.class, "(insertarModMediador) Alta en tabla P06B71T00_ENT_VINCULADAS. Consulta a ejecutar: "
							+ this.sql);
					pstmt.executeUpdate();
					i++;
				}
			}
		}
		
		if (datosModifMediador.isbActualizarCapacidadFinanciera()){
			if (datosModifMediador.getcFDeclaro()!=0){
				pstmt = this.prepareAlta80SQL(datosModifMediador, p06B64T00Datatype);
				P06BLog.send(0,P06bMng.class, "(insertarModMediador) Alta en tabla P06B80T00_CAPACIDADFINANCIERA. Consulta a ejecutar: "
						+ this.sql);
				pstmt.executeUpdate();
			}
		}


		//Obtener Documentacion adjunta
		List<P06B82T00Datatype> listaDocumentos = new ArrayList<P06B82T00Datatype>();
		if (ejgvDoc!=null && ejgvDoc.getAttachments()!=null){
			Integer contAttach=ejgvDoc.getAttachments().getAttachment().size();
			if (contAttach>0 ){
				for(int i=0;i<contAttach;i++){
					Attachment attachment = ejgvDoc.getAttachments().getAttachment().get(i);
					if (attachment.getID()!=null){
						P06B82T00Datatype documento = new P06B82T00Datatype();
						documento.setRoleIdEnPid(attachment.getRoleId());
						List<Language> listaIdiomas = attachment.getRoleName().getDescription().getLanguage(); 
						int j=0;
						while (j<listaIdiomas.size()){
							if (listaIdiomas.get(j).getLocale().equals(P06BConstantes.P06B_IDIOMA_EU)){
								documento.setRoleNameEusEnPid(listaIdiomas.get(j).getValue());
							}else if (listaIdiomas.get(j).getLocale().equals(P06BConstantes.P06B_IDIOMA_ES)){
								documento.setRoleNameCasEnPid(listaIdiomas.get(j).getValue());
							}
							j++;
						}
						documento.setReferenciaEnPid(attachment.getID());
						String nombreFichero= attachment.getSourceName();
				        int indPunto = nombreFichero.lastIndexOf('.');
				        if (indPunto!=-1){
							documento.setNombreEnPid(nombreFichero.substring(0,indPunto));
							documento.setExtensionEnPid(nombreFichero.substring(indPunto+1));
				        }else{
							documento.setNombreEnPid(nombreFichero);
							documento.setExtensionEnPid(null);
				        }
				        listaDocumentos.add(documento);
					}
				}
			}
		}
		if(listaDocumentos.size()>0){
			this.getInsertAdjuntosAPSQL(datosModifMediador, p06B64T00Datatype, listaDocumentos);
			P06BLog.send(0,P06bMng.class, "(insertarAltaMediador) Alta de adjuntos. Consulta a ejecutar: " + this.sql);
			stmt.executeUpdate(this.sql);
			P06BLog.send(0,P06bMng.class, "(insertarAltaMediador)  Alta de adjuntos ejecutada correctamente");
		}

		P06BLog.send(0,P06bMng.class, "(insertarModMediador) Completada");
	}
	
	
	/**
	 * Inserto la solicitud de reclamacin
	 * 
	 * @param solicitud
	 *            : Objeto de tipo AltaMediadores con los datos de negocio de la solicitud de reclamacin
	 *				a almacenar en base de datos
	 *: Array de ficheros adjuntados
	 *:Array de extension de ficheros adjuntados
	 * @throws Exception
	 *             : Lanza un objeto de tipo Exception en caso de haber existido
	 *             algn problema
	 */
	public void autorizarMediador(DatosMediadores datosModifMediador, P06B64T00Datatype p06B64T00Datatype, EjgvDocument ejgvDoc, ContextSubmissionEvent cData) throws SQLException {

		P06BLog.send(0,P06bMng.class, "(autorizarMediador) Completada");
	}
	
	
	/**
	 * Inserto la solicitud de reclamacin
	 * 
	 * @param solicitud
	 *            : Objeto de tipo AltaMediadores con los datos de negocio de la solicitud de reclamacin
	 *				a almacenar en base de datos
	 *: Array de ficheros adjuntados
	 *:Array de extension de ficheros adjuntados
	 * @throws Exception
	 *             : Lanza un objeto de tipo Exception en caso de haber existido
	 *             algn problema
	 */
	public void cancelacionMediador(DatosMediadores datosCancelacionMediador, P06B64T00Datatype p06B64T00Datatype, EjgvDocument ejgvDoc) throws SQLException {

		pstmt = this.prepareCancelacionSQL(datosCancelacionMediador, p06B64T00Datatype);
		pstmt.executeUpdate();

		//Obtener Documentacion adjunta
		List<P06B82T00Datatype> listaDocumentos = new ArrayList<P06B82T00Datatype>();
		if (ejgvDoc!=null && ejgvDoc.getAttachments()!=null){
			Integer contAttach=ejgvDoc.getAttachments().getAttachment().size();
			if (contAttach>0 ){
				for(int i=0;i<contAttach;i++){
					Attachment attachment = ejgvDoc.getAttachments().getAttachment().get(i);
					if (attachment.getID()!=null){
						P06B82T00Datatype documento = new P06B82T00Datatype();
						documento.setCorrelAtencPet(p06B64T00Datatype.getCorrelativo());
						documento.setRoleIdEnPid(attachment.getRoleId());
						List<Language> listaIdiomas = attachment.getRoleName().getDescription().getLanguage(); 
						int j=0;
						while (j<listaIdiomas.size()){
							if (listaIdiomas.get(j).getLocale().equals(P06BConstantes.P06B_IDIOMA_EU)){
								documento.setRoleNameEusEnPid(listaIdiomas.get(j).getValue());
							}else if (listaIdiomas.get(j).getLocale().equals(P06BConstantes.P06B_IDIOMA_ES)){
								documento.setRoleNameCasEnPid(listaIdiomas.get(j).getValue());
							}
							j++;
						}
						documento.setReferenciaEnPid(attachment.getID());
						String nombreFichero= attachment.getSourceName();
				        int indPunto = nombreFichero.lastIndexOf('.');
				        if (indPunto!=-1){
							documento.setNombreEnPid(nombreFichero.substring(0,indPunto));
							documento.setExtensionEnPid(nombreFichero.substring(indPunto+1));
				        }else{
							documento.setNombreEnPid(nombreFichero);
							documento.setExtensionEnPid(null);
				        }
				        listaDocumentos.add(documento);
					}
				}
			}
		}
		if(listaDocumentos.size()>0){
//			this.getInsertAdjuntosExpCancelSQL(datosCancelacionMediador, listaDocumentos);
			this.getInsertAdjuntosAPSQL(datosCancelacionMediador, p06B64T00Datatype, listaDocumentos);
			P06BLog.send(0,P06bMng.class, "(insertarAltaMediador) Alta de adjuntos. Consulta a ejecutar: " + this.sql);
			stmt.executeUpdate(this.sql);
			P06BLog.send(0,P06bMng.class, "(insertarAltaMediador)  Alta de adjuntos ejecutada correctamente");
		}		
		
		P06BLog.send(0,P06bMng.class, "(cancelacionMediador) Completada");
		
		pstmt.close();
	}
	
	
	/**
	 * Inserto la solicitud de reclamacin
	 * 
	 * @param solicitud
	 *            : Objeto de tipo AltaMediadores con los datos de negocio de la solicitud de reclamacin
	 *				a almacenar en base de datos
	 *: Array de ficheros adjuntados
	 *:Array de extension de ficheros adjuntados
	 * @throws Exception
	 *             : Lanza un objeto de tipo Exception en caso de haber existido
	 *             algn problema
	 */
	public void insertarAtencionPeticion(P06B64T00Datatype p06B64T00Datatype) throws SQLException {

		try {

//			stmt = con.createStatement();
			StringBuilder alta64SQL = new StringBuilder();
			
			alta64SQL.append("INSERT INTO " + P06BTablas.P06B_P06B64T00_TABLA + " ("); 
			alta64SQL.append(P06BTablas.P06B_P06B64_AP_CORRELATENCPETIC); 
			alta64SQL.append(", ");
			alta64SQL.append(P06BTablas.P06B_P06B64_AP_FECHA); 
			alta64SQL.append(", ");
			alta64SQL.append(P06BTablas.P06B_P06B64_AP_MENSAJE); 
			alta64SQL.append(", ");
			alta64SQL.append(P06BTablas.P06B_P06B64_AP_CONTEXTSUBMISSIONEVENT); 
			alta64SQL.append(", ");
			alta64SQL.append(P06BTablas.P06B_P06B64_AP_EJGVDOCUMENT); 
			alta64SQL.append(", ");
			alta64SQL.append(P06BTablas.P06B_P06B64_AP_IDSOL_TRAMITAGUNE); 
			alta64SQL.append(", ");
			alta64SQL.append(P06BTablas.P06B_P06B64_AP_FINALIZADA);
			alta64SQL.append(", ");
			alta64SQL.append(P06BTablas.P06B_P06B64_AP_MENSAJEERROR); 				
			alta64SQL.append(", ");
			alta64SQL.append(P06BTablas.P06B_P06B64_AP_ESTADO); 
			alta64SQL.append(", ");
			alta64SQL.append(P06BTablas.P06B_P06B64_AP_REGISTRYNUMBER); 
			alta64SQL.append(", ");
			alta64SQL.append(P06BTablas.P06B_P06B64_AP_ACTDOMSOC); 
			alta64SQL.append(", ");
			alta64SQL.append(P06BTablas.P06B_P06B64_AP_ACTCAPSOC); 
			alta64SQL.append(", ");
			alta64SQL.append(P06BTablas.P06B_P06B64_AP_ACTADM); 
			alta64SQL.append(", ");
			alta64SQL.append(P06BTablas.P06B_P06B64_AP_ACTORGDIR); 
			alta64SQL.append(", ");
			alta64SQL.append(P06BTablas.P06B_P06B64_AP_ACTATENCDEFCLIEN); 
			alta64SQL.append(", ");
			alta64SQL.append(P06BTablas.P06B_P06B64_AP_ACTCAPFINAN); 
			alta64SQL.append(", ");
			alta64SQL.append(P06BTablas.P06B_P06B64_AP_ACTENTVINC); 
			alta64SQL.append(", ");
			alta64SQL.append(P06BTablas.P06B_P06B64_AP_PROCEDIMIENTO); 
			alta64SQL.append(", ");
			alta64SQL.append(P06BTablas.P06B_P06B64_AP_NUMEXP); 
			alta64SQL.append(") VALUES (");
//			alta64SQL.append("P06B64SEQ00.NEXTVAL");
			alta64SQL.append("?");
			alta64SQL.append(", SYSDATE");
			alta64SQL.append(", ?");
			alta64SQL.append(", ?");
			alta64SQL.append(", ?");
			alta64SQL.append(", ?");
			alta64SQL.append(", ?");
			alta64SQL.append(", ?");
			alta64SQL.append(", ?");
			alta64SQL.append(", ?");
			alta64SQL.append(", ?");
			alta64SQL.append(", ?");
			alta64SQL.append(", ?");
			alta64SQL.append(", ?");
			alta64SQL.append(", ?");
			alta64SQL.append(", ?");
			alta64SQL.append(", ?");
			alta64SQL.append(", ?");
			alta64SQL.append(", ?");
			alta64SQL.append(")");
			this.sql =  alta64SQL.toString();

			pstmt = con.prepareStatement(this.sql);
			
			P06BLog.send(0,P06bMng.class, "(insertarAtencionPeticion) Alta en tabla P06B64T00_ATENDERPETICION. Consulta a ejecutar: " + this.sql);
			
			pstmt.setInt(1, p06B64T00Datatype.getCorrelativo());
			if (p06B64T00Datatype.getMensaje()!=null){
				pstmt.setClob(2, new StringReader(p06B64T00Datatype.getMensaje()));				
			}else{
				pstmt.setNull(2, java.sql.Types.CLOB);
			}
			if (p06B64T00Datatype.getContextSubmissionEvent()!=null){
				pstmt.setClob(3, new StringReader(p06B64T00Datatype.getContextSubmissionEvent()));				
			}else{
				pstmt.setNull(3, java.sql.Types.CLOB);
			}
			if (p06B64T00Datatype.getEjgvDocument()!=null){
				pstmt.setClob(4, new StringReader(p06B64T00Datatype.getEjgvDocument()));				
			}else{
				pstmt.setNull(4, java.sql.Types.CLOB);
			}
			if (p06B64T00Datatype.getIdSolicitudTramitagune()!=null){
				pstmt.setString(5, p06B64T00Datatype.getIdSolicitudTramitagune());
			}else{
				pstmt.setNull(5, java.sql.Types.VARCHAR);
			}
			if (p06B64T00Datatype.getMensajeError()!=null){
				pstmt.setBoolean(6, false);
				pstmt.setClob(7, new StringReader(p06B64T00Datatype.getMensajeError()));
			}else{
				pstmt.setBoolean(6, true);
				pstmt.setNull(7, java.sql.Types.CLOB);
			}
			pstmt.setInt(8, p06B64T00Datatype.getEstado());
			if (p06B64T00Datatype.getRegistryNumber()!=null){
				pstmt.setString(9, p06B64T00Datatype.getRegistryNumber());
			}else{
				pstmt.setNull(9, java.sql.Types.VARCHAR);
			}
			pstmt.setBoolean(10, p06B64T00Datatype.isbActualizarDomicilioSocial());
			pstmt.setBoolean(11, p06B64T00Datatype.isbActualizarCapitalSocial());
			pstmt.setBoolean(12, p06B64T00Datatype.isbActualizarAdministradores());
			pstmt.setBoolean(13, p06B64T00Datatype.isbActualizarOrganoDireccion());
			pstmt.setBoolean(14, p06B64T00Datatype.isbActualizarAtencionDefensaCliente());
			pstmt.setBoolean(15, p06B64T00Datatype.isbActualizarCapacidadFinanciera());
			pstmt.setBoolean(16, p06B64T00Datatype.isbActualizarEntidadesVinculadas());
			if (p06B64T00Datatype.getProcedimiento()!=null){
				pstmt.setString(17, p06B64T00Datatype.getProcedimiento());
			}else{
				pstmt.setNull(17, java.sql.Types.VARCHAR);
			}
			if (p06B64T00Datatype.getExpediente()!=null){
				if (p06B64T00Datatype.getProcedimiento()!=null && p06B64T00Datatype.getProcedimiento().equals(P06bMng.PROCEDIMIENTO_ALTA_REG_MEDIADORES_SEGUROS) && p06B64T00Datatype.getMensajeError()!=null){
					pstmt.setNull(18, java.sql.Types.VARCHAR);					
				}else{
					pstmt.setString(18, p06B64T00Datatype.getExpediente());					
				}
			}else{
				pstmt.setNull(18, java.sql.Types.VARCHAR);
			}
			
			pstmt.executeUpdate();

			P06BLog.send(0,P06bMng.class, "(insertarAtencionPeticion) Completada");
			
		} catch (SQLException sqle) {
			P06BLog.send(0,P06bMng.class, "(insertarAtencionPeticion) SQLException: " + sqle.getMessage());
			throw sqle;
		} finally {
			if (pstmt != null) {
				pstmt.close();
			}
		}
	}
	
	
	/**
	 * Inserto la solicitud de reclamacin
	 * 
	 * @param solicitud
	 *            : Objeto de tipo AltaMediadores con los datos de negocio de la solicitud de reclamacin
	 *				a almacenar en base de datos
	 *: Array de ficheros adjuntados
	 *:Array de extension de ficheros adjuntados
	 * @throws Exception
	 *             : Lanza un objeto de tipo Exception en caso de haber existido
	 *             algn problema
	 */
	public void modificarAtencionPeticion(P06B64T00Datatype p06B64T00Datatype) throws SQLException {

		try {

//			stmt = con.createStatement();
			StringBuilder alta64SQL = new StringBuilder();
			
			alta64SQL.append("UPDATE " + P06BTablas.P06B_P06B64T00_TABLA + " SET "); 
			alta64SQL.append(P06BTablas.P06B_P06B64_AP_FECHA + " = SYSDATE"); 
			alta64SQL.append(", ");
			alta64SQL.append(P06BTablas.P06B_P06B64_AP_MENSAJE + " = ?"); 
			alta64SQL.append(", ");
			alta64SQL.append(P06BTablas.P06B_P06B64_AP_CONTEXTSUBMISSIONEVENT + " = ?"); 
			alta64SQL.append(", ");
			alta64SQL.append(P06BTablas.P06B_P06B64_AP_EJGVDOCUMENT + " = ?"); 
			alta64SQL.append(", ");
			alta64SQL.append(P06BTablas.P06B_P06B64_AP_IDSOL_TRAMITAGUNE + " = ?"); 
			alta64SQL.append(", ");
			alta64SQL.append(P06BTablas.P06B_P06B64_AP_FINALIZADA + " = ?");
			alta64SQL.append(", ");
			alta64SQL.append(P06BTablas.P06B_P06B64_AP_MENSAJEERROR + " = ?");
			alta64SQL.append(", ");
			alta64SQL.append(P06BTablas.P06B_P06B64_AP_ESTADO + " = ?"); 
			alta64SQL.append(", ");
			alta64SQL.append(P06BTablas.P06B_P06B64_AP_REGISTRYNUMBER + " = ?"); 
			alta64SQL.append(", ");
			alta64SQL.append(P06BTablas.P06B_P06B64_AP_ACTDOMSOC + " = ?"); 
			alta64SQL.append(", ");
			alta64SQL.append(P06BTablas.P06B_P06B64_AP_ACTCAPSOC + " = ?"); 
			alta64SQL.append(", ");
			alta64SQL.append(P06BTablas.P06B_P06B64_AP_ACTADM + " = ?"); 
			alta64SQL.append(", ");
			alta64SQL.append(P06BTablas.P06B_P06B64_AP_ACTORGDIR + " = ?"); 
			alta64SQL.append(", ");
			alta64SQL.append(P06BTablas.P06B_P06B64_AP_ACTATENCDEFCLIEN + " = ?"); 
			alta64SQL.append(", ");
			alta64SQL.append(P06BTablas.P06B_P06B64_AP_ACTCAPFINAN + " = ?"); 
			alta64SQL.append(", ");
			alta64SQL.append(P06BTablas.P06B_P06B64_AP_ACTENTVINC + " = ?"); 
			alta64SQL.append(", ");
			alta64SQL.append(P06BTablas.P06B_P06B64_AP_PROCEDIMIENTO + " = ?"); 
			alta64SQL.append(", ");
			alta64SQL.append(P06BTablas.P06B_P06B64_AP_NUMEXP + " = ?"); 
			alta64SQL.append(" WHERE " + P06BTablas.P06B_P06B64_AP_CORRELATENCPETIC + " = ?");
			this.sql =  alta64SQL.toString();

			pstmt = con.prepareStatement(this.sql);
			
			P06BLog.send(0,P06bMng.class, "(modificarAtencionPeticion) Modif. en tabla P06B64T00_ATENDERPETICION. Consulta a ejecutar: " + this.sql);
			
			int nColumna = 0;
			nColumna++;
			if (p06B64T00Datatype.getMensaje()!=null){
				pstmt.setClob(nColumna, new StringReader(p06B64T00Datatype.getMensaje()));				
			}else{
				pstmt.setNull(nColumna, java.sql.Types.CLOB);
			}
			nColumna++;
			if (p06B64T00Datatype.getContextSubmissionEvent()!=null){
				pstmt.setClob(nColumna, new StringReader(p06B64T00Datatype.getContextSubmissionEvent()));				
			}else{
				pstmt.setNull(nColumna, java.sql.Types.CLOB);
			}
			nColumna++;
			if (p06B64T00Datatype.getEjgvDocument()!=null){
				pstmt.setClob(nColumna, new StringReader(p06B64T00Datatype.getEjgvDocument()));				
			}else{
				pstmt.setNull(nColumna, java.sql.Types.CLOB);
			}
			nColumna++;				
			if (p06B64T00Datatype.getIdSolicitudTramitagune()!=null){
				pstmt.setString(nColumna, p06B64T00Datatype.getIdSolicitudTramitagune());
			}else{
				pstmt.setNull(nColumna, java.sql.Types.VARCHAR);
			}
			nColumna++;
			if (p06B64T00Datatype.getMensajeError()!=null){
				pstmt.setBoolean(nColumna, false);
				nColumna++;				
				pstmt.setClob(nColumna, new StringReader(p06B64T00Datatype.getMensajeError()));
			}else{
				pstmt.setBoolean(nColumna, true);
				nColumna++;				
				pstmt.setNull(nColumna, java.sql.Types.CLOB);
			}
			nColumna++;				
			pstmt.setInt(nColumna, p06B64T00Datatype.getEstado());
			nColumna++;				
			if (p06B64T00Datatype.getRegistryNumber()!=null){
				pstmt.setString(nColumna, p06B64T00Datatype.getRegistryNumber());
			}else{
				pstmt.setNull(nColumna, java.sql.Types.VARCHAR);
			}
			nColumna++;				
			pstmt.setBoolean(nColumna, p06B64T00Datatype.isbActualizarDomicilioSocial());
			nColumna++;				
			pstmt.setBoolean(nColumna, p06B64T00Datatype.isbActualizarCapitalSocial());
			nColumna++;				
			pstmt.setBoolean(nColumna, p06B64T00Datatype.isbActualizarAdministradores());
			nColumna++;				
			pstmt.setBoolean(nColumna, p06B64T00Datatype.isbActualizarOrganoDireccion());
			nColumna++;				
			pstmt.setBoolean(nColumna, p06B64T00Datatype.isbActualizarAtencionDefensaCliente());
			nColumna++;				
			pstmt.setBoolean(nColumna, p06B64T00Datatype.isbActualizarCapacidadFinanciera());
			nColumna++;				
			pstmt.setBoolean(nColumna, p06B64T00Datatype.isbActualizarEntidadesVinculadas());
			nColumna++;				
			if (p06B64T00Datatype.getProcedimiento()!=null){
				pstmt.setString(nColumna, p06B64T00Datatype.getProcedimiento());
			}else{
				pstmt.setNull(nColumna, java.sql.Types.VARCHAR);
			}
			nColumna++;				
			if (p06B64T00Datatype.getExpediente()!=null){
				pstmt.setString(nColumna, p06B64T00Datatype.getExpediente());				
			}else{
				pstmt.setNull(nColumna, java.sql.Types.VARCHAR);
			}
			nColumna++;				
			pstmt.setInt(nColumna, p06B64T00Datatype.getCorrelativo());
			
			pstmt.executeUpdate();

			P06BLog.send(0,P06bMng.class, "(modificarAtencionPeticion) Completada");
			
		} catch (SQLException sqle) {
			P06BLog.send(0,P06bMng.class, "(modificarAtencionPeticion) SQLException: " + sqle.getMessage());
			throw sqle;
		} finally {
			if (pstmt != null) {
				pstmt.close();
			}
		}
	}
	
	
	/**
	 * Obtengo el cdigo mximo de solicitud de alta de plan de previsin
	 * 
	 * @return Devuelve un objeto int con el cdigo de solicitud mayor
	 *         almacenado en base de datos
	 * 
	 * @throws Exception
	 *             : Lanza un objeto de tipo Exception en caso de haber existido
	 *             algn problema
	 */
	public int getLastExpediente() throws SQLException {

		int lastExpediente = -1;

		try {
			stmt = con.createStatement();

			this.sql = "SELECT NVL(MAX(P06B21_NUMEXP),1) from p06b21t00_expedientes";

			P06BLog.send(0,P06bMng.class, "(getLastExpediente) Consulta a ejecutar: "
					+ this.sql);

			rs = stmt.executeQuery(this.sql);

			P06BLog.send(0,P06bMng.class, "(getLastExpediente) Consulta correctamente ejecutada");

			while (rs.next()) {
				lastExpediente = rs.getInt(1);
			}

		} catch (SQLException e) {
			P06BLog.send(0,P06bMng.class, "(getLastExpediente) Error al ejecutar la consulta");
			throw e;
		} finally {
			if (this.rs != null) {
				this.rs.close();
			}
			if (this.stmt != null) {
				this.stmt.close();
			}
		}
		return lastExpediente;
	}
	
	/**
	 * Obtengo el cdigo mximo de solicitud de alta de plan de previsin
	 * 
	 * @return Devuelve un objeto int con el cdigo de solicitud mayor
	 *         almacenado en base de datos
	 * 
	 * @throws Exception
	 *             : Lanza un objeto de tipo Exception en caso de haber existido
	 *             algn problema
	 */
	public int getCorrelAtencPetic() throws SQLException {

		int nCorrelAtencPetic = -1;

		stmt = con.createStatement();

		this.sql = "SELECT P06B64SEQ00.NEXTVAL FROM DUAL";

		rs = stmt.executeQuery(this.sql);

		rs.next();
		nCorrelAtencPetic = rs.getInt(1);
		return nCorrelAtencPetic;
	}
	
	/**
	 * Obtengo el cdigo mximo de solicitud de alta de plan de previsin
	 * 
	 * @return Devuelve un objeto int con el cdigo de solicitud mayor
	 *         almacenado en base de datos
	 * 
	 * @throws Exception
	 *             : Lanza un objeto de tipo Exception en caso de haber existido
	 *             algn problema
	 */
	public int getExpedienteModificado(String identificador, String tipoMediador) throws SQLException, P06BModMediadorException {

		int expedienteModificado = -1;

		try {
			StringBuilder sb = new StringBuilder();
			String sNumExpDesdeExpFormateado = "TO_NUMBER(SUBSTR(" + P06BTablas.P06B_P06B20_NUMEXP + ",LENGTH(" + P06BTablas.P06B_P06B20_CLASE + ")+2," + P06BConstantes.P06B_NUMPOSICIONES_CLAVE + "))";
			sb.append("select " + sNumExpDesdeExpFormateado);
			sb.append(" from " + P06BTablas.P06B_P06B20T00_TABLA);
			sb.append(" where " + P06BTablas.P06B_P06B20_IDENTIFICADOR + "= ?");
			sb.append(" and " + P06BTablas.P06B_P06B20_CLASE + " = ?");
			sb.append(" and " + P06BTablas.P06B_P06B20_ESTADO + " = ?");

			this.sql = sb.toString();

			P06BLog.send(0,P06bMng.class, "(getExpedienteModificado) Consulta a ejecutar: " + this.sql);

	        pstmt = con.prepareStatement(sql);
	        pstmt.setString(1, identificador);
	        pstmt.setString(2, tipoMediador);
	        pstmt.setString(3, P06BConstantes.P06B_CORREDORES_ESTADO_ALTA);
			rs = pstmt.executeQuery();

			P06BLog.send(0,P06bMng.class, "(getExpedienteModificado) Consulta correctamente ejecutada");

			//Si hay varios expedientes se devuelve nulo para que se el mismo error que cuando no hay expediente
			//de que no se puede determinar el expediente.
			if (!rs.next()){
				throw new P06BModMediadorException("No hay expedientes en estado de alta para " + identificador + " correspondientes al tipo de mediador " + tipoMediador);
			}
			expedienteModificado = rs.getInt(sNumExpDesdeExpFormateado);
			if (rs.next()){
				expedienteModificado = -1;
				throw new P06BModMediadorException("Hay varios expedientes en estado de alta para " + identificador + " correspondientes al tipo de mediador " + tipoMediador);
			}
		} catch (SQLException sqle) {
			P06BLog.send(0,P06bMng.class, "(getExpedienteModificado) Error al ejecutar la consulta: " + sqle.getMessage());
			throw sqle;
		} finally {
			if (this.rs != null) {
				this.rs.close();
			}
			if (this.pstmt != null) {
				this.pstmt.close();
			}
		}
		return expedienteModificado;
	}
	
	/**
	 * Obtengo el cdigo mximo de solicitud de alta de plan de previsin
	 * 
	 * @return Devuelve un objeto int con el cdigo de solicitud mayor
	 *         almacenado en base de datos
	 * 
	 * @throws Exception
	 *             : Lanza un objeto de tipo Exception en caso de haber existido
	 *             algn problema
	 */
	public String getExpedienteDeAlta(String identificador) throws SQLException, P06BModMediadorException {

		String expedienteDeAlta = null;

		try {
			StringBuilder sb = new StringBuilder();
			String sNumExpFormateado = P06BTablas.P06B_P06B20_NUMEXP;
			sb.append("select " + sNumExpFormateado);
			sb.append(" from " + P06BTablas.P06B_P06B20T00_TABLA);
			sb.append(" where " + P06BTablas.P06B_P06B20_IDENTIFICADOR + "= ?");
//			sb.append(" and " + P06BTablas.P06B_P06B20_ESTADO + " != ?");
			sb.append(" and " + P06BTablas.P06B_P06B20_ESTADO + " = ?");

			this.sql = sb.toString();

			P06BLog.send(0,P06bMng.class, "(getExpedienteDeAlta) Consulta a ejecutar: " + this.sql);

	        pstmt = con.prepareStatement(sql);
	        pstmt.setString(1, identificador);
//	        pstmt.setString(2, P06BConstantes.P06B_CORREDORES_ESTADO_BAJA);
	        pstmt.setString(2, P06BConstantes.P06B_CORREDORES_ESTADO_ALTA);
			rs = pstmt.executeQuery();

			P06BLog.send(0,P06bMng.class, "(getExpedienteDeAlta) Consulta correctamente ejecutada");

			//Si hay varios expedientes se devuelve nulo para que se el mismo error que cuando no hay expediente
			//de que no se puede determinar el expediente.
			if (!rs.next()){
//				throw new P06BModMediadorException("No hay expedientes en estado diferente de baja para " + identificador);
				throw new P06BModMediadorException("No se encontr expediente de alta para " + identificador);
			}
			expedienteDeAlta = rs.getString(sNumExpFormateado);
			if (rs.next()){
				expedienteDeAlta = null;
//				throw new P06BModMediadorException("Hay varios expedientes en estado diferente de baja para " + identificador);
				throw new P06BModMediadorException("No se pudo determinar el expediente. Hay varios expedientes de alta para " + identificador);
			}
		} catch (SQLException sqle) {
			P06BLog.send(0,P06bMng.class, "(getExpedienteDeAlta) Error al ejecutar la consulta: " + sqle.getMessage());
			throw sqle;
		} finally {
			if (this.rs != null) {
				this.rs.close();
			}
			if (this.pstmt != null) {
				this.pstmt.close();
			}
		}
		return expedienteDeAlta;
	}
	
	/**
	 * Obtengo el cdigo mximo de solicitud de alta de plan de previsin
	 * 
	 * @return Devuelve un objeto int con el cdigo de solicitud mayor
	 *         almacenado en base de datos
	 * 
	 * @throws Exception
	 *             : Lanza un objeto de tipo Exception en caso de haber existido
	 *             algn problema
	 */
	public void ExcepcionPorIdentificadorEnExpedienteEstadoNoBaja(String identificador) throws SQLException, P06BModMediadorException {

		String expedienteExistente = null;

		try {
			StringBuilder sb = new StringBuilder();
			String sNumExpExistente = P06BTablas.P06B_P06B20_NUMEXP;
			sb.append("select " + sNumExpExistente);
			sb.append(" from " + P06BTablas.P06B_P06B20T00_TABLA);
			sb.append(" where " + P06BTablas.P06B_P06B20_IDENTIFICADOR + "= ?");
			sb.append(" and " + P06BTablas.P06B_P06B20_ESTADO + " != ?");
			sb.append(" and " + P06BTablas.P06B_P06B20_ESTADO + " != ?");
			sb.append(" order by " + P06BTablas.P06B_P06B20_NUMEXP);

			this.sql = sb.toString();

			P06BLog.send(0,P06bMng.class, "(ExcepcionPorIdentificadorEnExpedienteEstadoNoBaja) Consulta a ejecutar: " + this.sql);

	        pstmt = con.prepareStatement(sql);
	        pstmt.setString(1, identificador);
	        pstmt.setString(2, P06BConstantes.P06B_CORREDORES_ESTADO_BAJA);
	        pstmt.setString(3, P06BConstantes.P06B_CORREDORES_ESTADO_ALTA_RECHAZADA);
			rs = pstmt.executeQuery();

			P06BLog.send(0,P06bMng.class, "(ExcepcionPorIdentificadorEnExpedienteEstadoNoBaja) Consulta correctamente ejecutada");

			//Si hay varios expedientes se devuelve nulo para que se el mismo error que cuando no hay expediente
			//de que no se puede determinar el expediente.
			if (!rs.next()){
				return;
			}
			expedienteExistente = rs.getString(sNumExpExistente);
			throw new P06BModMediadorException("El titular " + identificador + " ya tiene un expediente " + expedienteExistente + " activo (estado distinto a 'baja' y 'alta rechazada').");
		} catch (SQLException sqle) {
			P06BLog.send(0,P06bMng.class, "(ExcepcionPorIdentificadorEnExpedienteEstadoNoBaja) Error al ejecutar la consulta: " + sqle.getMessage());
			throw sqle;
		} finally {
			if (this.rs != null) {
				this.rs.close();
			}
			if (this.pstmt != null) {
				this.pstmt.close();
			}
		}
	}
	
	/**
	 * Obtiene la SQL asociada al alta de una solicitud de reclamacin
	 * 
	 * @param solicitud
	 *            : Objeto de tipo AltaMediadores con los datos de negocio de la solicitud de reclamacin
	 *            a almacenar en base de datos
	 */
	private void getAlta21SQL(DatosMediadores mediador) {

		String alta21SQL = "";
		
		alta21SQL = "INSERT INTO P06B21T00_EXPEDIENTES (P06B21_TIPOEXP, P06B21_NUMEXP)" +
		"VALUES (" + this.getStringValues(mediador.obtenerClaseMediador()) + ", " + mediador.getExpediente() + ")";
		this.sql =  alta21SQL;
	}
	
	/**
	 * Obtiene la SQL asociada al alta de una solicitud de reclamacin
	 * 
	 * @param solicitud
	 *            : Objeto de tipo AltaMediadores con los datos de negocio de la solicitud de reclamacin
	 *            a almacenar en base de datos
	 */
	private void getAlta20SQL(DatosMediadores mediador, P06B64T00Datatype p06B64T00Datatype) {

		String altaTramitaguneSQL = "";
		
		altaTramitaguneSQL = "INSERT INTO P06B20T00_CORREDORES (P06B20_NUMEXP,P06B20_CLASE,P06B20_IDENTIFICADOR,P06B20_RAZSOC,P06B20_NOMBRE,P06B20_APE1,P06B20_APE2,P06B20_DOMICI,P06B20_CODMUN,P06B20_LOCALI,P06B20_CODPRO,P06B20_CODPST,P06B20_TELEFOT,P06B20_MAIL,P06B20_WEB,P06B20_CURSO,P06B20_ACREDITA,P06B20_ESTADO,P06B20_FECHAAL,P06B20_CAPSOC,P06B20_PATICIPA,P06B20_ORIGEN,P06B20_ATENCPETICINCORPORADA)";

		StringBuilder sbValues = new StringBuilder("");
		String sP06B20_NUMEXP = mediador.formatearExpediente();
		String sP06B20_CLASE = mediador.obtenerClaseMediador();
		String sP06B20_IDENTIFICADOR = mediador.getTitId();
		String sP06B20_RAZSOC = "";
		String sP06B20_NOMBRE = "";
		String sP06B20_APE1 = "";
		String sP06B20_APE2 = "";
		if(mediador.getTitTipoId().equals("2")){
			//Si es un CIF (PersonType=2) en maysculas.
			sP06B20_RAZSOC = mediador.getTitRazonSocial();
		}else{
			sP06B20_NOMBRE = mediador.getTitNombre();
			sP06B20_APE1 = mediador.getTitApe1();
			sP06B20_APE2 = mediador.getTitApe2();
		}
		String sP06B20_DOMICI = mediador.getdACalle() + " " + mediador.getdAPortal() + " " + mediador.getdAPiso() + mediador.getdALetra();
		String sP06B20_CODMUN = mediador.getdAMunicipio();
		String sP06B20_LOCALI = mediador.getdALocalidad();
		String sP06B20_CODPRO = mediador.getdAProvincia();
		String sP06B20_CODPST = mediador.getdACodigoPostal();
		String sP06B20_TELEFOT = mediador.getdATelefono();
		String sP06B20_MAIL = mediador.getdAEMail();
		String sP06B20_WEB = mediador.getdAWeb();
		String sP06B20_CURSO = "SI";
		String sP06B20_ACREDITA = "SI";
		String sP06B20_ESTADO = P06BConstantes.P06B_CORREDORES_ESTADO_PDTE_ALTA;
		String sP06B20_FECHAAL = "TO_DATE(" + this.getStringValues(mediador.getFechaEfectos()) + ",'DD/MM/YYYY HH24:MI:SS')";
//		String sP06B20_CAPSOC = ((Integer)mediador.getpSCapitalSocial()).toString();
//		String sP06B20_PATICIPA = ((Integer)mediador.getpSNumeroParticipaciones()).toString();
		String sP06B20_CAPSOC = mediador.getpSCapitalSocial();
		String sP06B20_PATICIPA = mediador.getpSNumeroParticipaciones();
		
		sbValues.append(" VALUES ");
		sbValues.append("(");
		sbValues.append(this.getStringValues(sP06B20_NUMEXP));
		sbValues.append(",");
		sbValues.append(this.getStringValues(sP06B20_CLASE));
		sbValues.append(",");
		sbValues.append(this.getStringValues(sP06B20_IDENTIFICADOR));
		sbValues.append(",");
		sbValues.append(this.getStringValues(sP06B20_RAZSOC));
		sbValues.append(",");
		sbValues.append(this.getStringValues(sP06B20_NOMBRE));
		sbValues.append(",");
		sbValues.append(this.getStringValues(sP06B20_APE1));
		sbValues.append(",");
		sbValues.append(this.getStringValues(sP06B20_APE2));
		sbValues.append(",");
		sbValues.append(this.getStringValues(sP06B20_DOMICI));
		sbValues.append(",");
		sbValues.append(Integer.parseInt(sP06B20_CODMUN));
		sbValues.append(",");
//		sbValues.append(Long.parseLong(sP06B20_LOCALI));
		sbValues.append(this.getStringValues(sP06B20_LOCALI));
		sbValues.append(",");
		sbValues.append(Integer.parseInt(sP06B20_CODPRO));
		sbValues.append(",");
		sbValues.append(this.getStringValues(sP06B20_CODPST));
		sbValues.append(",");
		sbValues.append(this.getStringValues(sP06B20_TELEFOT));
		sbValues.append(",");
		sbValues.append(this.getStringValues(sP06B20_MAIL));
		sbValues.append(",");
		sbValues.append(this.getStringValues(sP06B20_WEB));
		sbValues.append(",");
		sbValues.append(this.getStringValues(sP06B20_CURSO));
		sbValues.append(",");
		sbValues.append(this.getStringValues(sP06B20_ACREDITA));
		sbValues.append(",");
		sbValues.append(this.getStringValues(sP06B20_ESTADO));
		sbValues.append(",");
		sbValues.append(sP06B20_FECHAAL);
		sbValues.append(",");
		sbValues.append(Integer.parseInt(sP06B20_CAPSOC));
		sbValues.append(",");
		sbValues.append(Integer.parseInt(sP06B20_PATICIPA));
		sbValues.append(",");
		sbValues.append(P06BConstantes.P06B_CORREDORES_ORIGEN_TRAMITAGUNE);
		sbValues.append(",");
		sbValues.append(p06B64T00Datatype.getCorrelativo());
		sbValues.append(")");
		
		this.sql =  altaTramitaguneSQL + " " + sbValues.toString();
	}
	
	/**
	 * Obtiene la SQL asociada al alta de una solicitud de reclamacin
	 * 
	 * @param solicitud
	 *            : Objeto de tipo AltaMediadores con los datos de negocio de la solicitud de reclamacin
	 *            a almacenar en base de datos
	 * @throws SQLException 
	 */
	private PreparedStatement prepareAlta20SQL(DatosMediadores mediador, P06B64T00Datatype p06B64T00Datatype) throws SQLException {

		StringBuilder sql = new StringBuilder();
		
		sql.append("INSERT INTO " + P06BTablas.P06B_P06B20T00_TABLA); 
		sql.append(" ( "); 
		sql.append(P06BTablas.P06B_P06B20_NUMEXP + ", "); 
		sql.append(P06BTablas.P06B_P06B20_CLASE + ", "); 
		sql.append(P06BTablas.P06B_P06B20_IDENTIFICADOR + ", "); 
		sql.append(P06BTablas.P06B_P06B20_RAZSOC + ", "); 
		sql.append(P06BTablas.P06B_P06B20_NOMBRE + ", "); 
		sql.append(P06BTablas.P06B_P06B20_APE1 + ", "); 
		sql.append(P06BTablas.P06B_P06B20_APE2 + ", "); 
		sql.append(P06BTablas.P06B_P06B20_DOMICI + ", "); 
		sql.append(P06BTablas.P06B_P06B20_CODMUN + ", "); 
		sql.append(P06BTablas.P06B_P06B20_LOCALI + ", "); 
		sql.append(P06BTablas.P06B_P06B20_CODPRO + ", "); 
		sql.append(P06BTablas.P06B_P06B20_CODPST + ", "); 
		sql.append(P06BTablas.P06B_P06B20_TELEFOT + ", "); 
		sql.append(P06BTablas.P06B_P06B20_MAIL + ", "); 
		sql.append(P06BTablas.P06B_P06B20_WEB + ", "); 
		sql.append(P06BTablas.P06B_P06B20_CURSO + ", "); 
		sql.append(P06BTablas.P06B_P06B20_ACREDITA + ", "); 
		sql.append(P06BTablas.P06B_P06B20_ESTADO + ", ");
		sql.append(P06BTablas.P06B_P06B20_FECHAAL + ", ");
		sql.append(P06BTablas.P06B_P06B20_CAPSOC + ", ");
		sql.append(P06BTablas.P06B_P06B20_PATICIPA + ", ");
		sql.append(P06BTablas.P06B_P06B20_ORIGEN + ", ");
		sql.append(P06BTablas.P06B_P06B20_ATENCPETICINCORPORADA + ", ");
		sql.append(P06BTablas.P06B_P06B20_TIPOATENCIONCLIENTE);
		sql.append(" ) VALUES ( ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, TO_DATE(?,'DD/MM/YYYY HH24:MI:SS'), TO_NUMBER(?), ?, ?, ?, ? )"); 

		this.sql =  sql.toString();
		pstmt = con.prepareStatement(this.sql);
		
//		int nDesfaseANumColTotal = 0;
//		if (){
//			nDesfaseANumColTotal += 1;
//		}else{
//			nDesfaseANumColTotal += 1;
//		}
		
		pstmt.setString(1, mediador.formatearExpediente());
		pstmt.setString(2, mediador.obtenerClaseMediador());
		pstmt.setString(3, mediador.getTitId());
//		if(mediador.getTitTipoId().equals("2")){
			pstmt.setString(4, mediador.getTitRazonSocial());			
//		}
//		else{
			pstmt.setString(5, mediador.getTitNombre());
			pstmt.setString(6, mediador.getTitApe1());
			pstmt.setString(7, mediador.getTitApe2());			
//		}
		pstmt.setString(8, mediador.getdACalle() + " " + mediador.getdAPortal() + " " + mediador.getdAPiso() + mediador.getdALetra());

		String municipio = null;
		if (mediador.getdAMunicipio()!=null && !"".equals(mediador.getdAMunicipio().trim())){
			municipio = ((Integer)Integer.parseInt(mediador.getdAMunicipio())).toString();
		}
		pstmt.setString(9, municipio);

		String localidad = null;
		if (mediador.getdALocalidad()!=null && !"".equals(mediador.getdALocalidad().trim())){
			localidad = ((Integer)Integer.parseInt(mediador.getdALocalidad())).toString();
		}
		pstmt.setString(10, localidad);

		String provincia = null;
		if (mediador.getdAProvincia()!=null && !"".equals(mediador.getdAProvincia().trim())){
			provincia = ((Integer)Integer.parseInt(mediador.getdAProvincia())).toString();
		}
		pstmt.setString(11, provincia);

		pstmt.setString(12, mediador.getdACodigoPostal());
		pstmt.setString(13, mediador.getdATelefono());
		pstmt.setString(14, mediador.getdAEMail());
		pstmt.setString(15, mediador.getdAWeb());
		pstmt.setString(16, "SI");
		pstmt.setString(17, "SI");
		pstmt.setString(18, P06BConstantes.P06B_CORREDORES_ESTADO_PDTE_ALTA);
		pstmt.setString(19, mediador.getFechaEfectos());
		P06BLog.send(0,P06bMng.class, "(prepareAlta20SQL) mediador.getpSCapitalSocial(): " + mediador.getpSCapitalSocial());
		pstmt.setString(20, mediador.getpSCapitalSocial());
		pstmt.setString(21, mediador.getpSNumeroParticipaciones());
		pstmt.setInt(22, P06BConstantes.P06B_CORREDORES_ORIGEN_TRAMITAGUNE);
		pstmt.setInt(23, p06B64T00Datatype.getCorrelativo());
		String tipoAtencionCliente = null;
		if (mediador.getaCTAtencioncliente()==null){
			tipoAtencionCliente = P06BConstantes.P06B_AC_NOPROCEDE;
		}else if ("".equals(mediador.getaCTAtencioncliente())){
			tipoAtencionCliente = P06BConstantes.P06B_AC_PENDIENTEINFORMAR;
		}else{
			tipoAtencionCliente = mediador.getaCTAtencioncliente();
		}
		pstmt.setString(24, tipoAtencionCliente);
		
		return pstmt;		
	}
	
	/**
	 */
	private PreparedStatement prepareAlta70SQL(DatosMediadores mediador, P06B64T00Datatype p06B64T00Datatype) throws SQLException {

		StringBuilder alta70SQL = new StringBuilder();
		
		alta70SQL.append("INSERT INTO " + P06BTablas.P06B_P06B70T00_TABLA + " ("); 
		alta70SQL.append(P06BTablas.P06B_P06B70_CO_CORRELATENCPETIC); 
		alta70SQL.append(", ");
		alta70SQL.append(P06BTablas.P06B_P06B70_CO_NUMEXP); 
		alta70SQL.append(", ");
		alta70SQL.append(P06BTablas.P06B_P06B70_CO_CLASE); 
		alta70SQL.append(", ");
		alta70SQL.append(P06BTablas.P06B_P06B70_CO_IDENTIFICADOR); 
		if (mediador.getTitTipoId().equals("2")){
			alta70SQL.append(", ");
			alta70SQL.append(P06BTablas.P06B_P06B70_CO_RAZSOC); 
		}else{
			alta70SQL.append(", ");
			alta70SQL.append(P06BTablas.P06B_P06B70_CO_NOMBRE); 
			alta70SQL.append(", ");
			alta70SQL.append(P06BTablas.P06B_P06B70_CO_APE1); 
			alta70SQL.append(", ");
			alta70SQL.append(P06BTablas.P06B_P06B70_CO_APE2); 
		}
		alta70SQL.append(", ");
		alta70SQL.append(P06BTablas.P06B_P06B70_CO_DOMICI);
		if (mediador.getdAMunicipio()!=null&&!mediador.getdAMunicipio().equals("")){
			alta70SQL.append(", ");
			alta70SQL.append(P06BTablas.P06B_P06B70_CO_CODMUN);	
		}
		if (mediador.getdAProvincia()!=null&&!mediador.getdAProvincia().equals("")){
			alta70SQL.append(", ");
			alta70SQL.append(P06BTablas.P06B_P06B70_CO_CODPRO); 
		}
		alta70SQL.append(", ");
		alta70SQL.append(P06BTablas.P06B_P06B70_CO_CODPST); 
		alta70SQL.append(", ");
		alta70SQL.append(P06BTablas.P06B_P06B70_CO_TELEFONO); 
		alta70SQL.append(", ");
		alta70SQL.append(P06BTablas.P06B_P06B70_CO_MAIL); 
		alta70SQL.append(", ");
		alta70SQL.append(P06BTablas.P06B_P06B70_CO_WEB); 
		alta70SQL.append(", ");
		alta70SQL.append(P06BTablas.P06B_P06B70_CO_CAPSOC); 
		alta70SQL.append(", ");
		alta70SQL.append(P06BTablas.P06B_P06B70_CO_PATICIPA); 
		alta70SQL.append(", ");
		alta70SQL.append(P06BTablas.P06B_P06B70_CO_TIPOATENCIONCLIENTE); 
		alta70SQL.append(") VALUES (");
		alta70SQL.append("?");
		alta70SQL.append(", ?");
		alta70SQL.append(", ?");
		alta70SQL.append(", ?");
		if (mediador.getTitTipoId().equals("2")){
			alta70SQL.append(", ?");
		}else{
			alta70SQL.append(", ?");
			alta70SQL.append(", ?");
			alta70SQL.append(", ?");
		}
		alta70SQL.append(", ?");
		if (mediador.getdAMunicipio()!=null&&!mediador.getdAMunicipio().equals("")){
			alta70SQL.append(", ?");			
		}
		if (mediador.getdAProvincia()!=null&&!mediador.getdAProvincia().equals("")){
			alta70SQL.append(", ?");
		}			
		alta70SQL.append(", ?");
		alta70SQL.append(", ?");
		alta70SQL.append(", ?");
		alta70SQL.append(", ?");
		alta70SQL.append(", TO_NUMBER(?)");
		alta70SQL.append(", ?");
		alta70SQL.append(", ?");
		alta70SQL.append(")");

		this.sql =  alta70SQL.toString();
		pstmt = con.prepareStatement(this.sql);
		
		int nDesfaseANumColTotal = 0;
		pstmt.setInt(1, p06B64T00Datatype.getCorrelativo());
		pstmt.setString(2, mediador.formatearExpediente());
		pstmt.setString(3, mediador.obtenerClaseMediador());
		pstmt.setString(4, mediador.getTitId());
		if (mediador.getTitTipoId().equals("2")){
			pstmt.setString(5, mediador.getTitRazonSocial());
			nDesfaseANumColTotal += 3;
		}else{
			pstmt.setString(5, mediador.getTitNombre());
			pstmt.setString(6, mediador.getTitApe1());
			pstmt.setString(7, mediador.getTitApe2());
			nDesfaseANumColTotal += 1;
		}
		pstmt.setString(9-nDesfaseANumColTotal, mediador.getdACalle() + " " + mediador.getdAPortal() + " " + mediador.getdAPiso() + mediador.getdALetra());
		if (mediador.getdAMunicipio()!=null&&!mediador.getdAMunicipio().equals("")){
			pstmt.setInt(10-nDesfaseANumColTotal, Integer.parseInt(mediador.getdAMunicipio()));
		}else{
			nDesfaseANumColTotal += 1;
		}
		if (mediador.getdAProvincia()!=null&&!mediador.getdAProvincia().equals("")){
			pstmt.setInt(11-nDesfaseANumColTotal, Integer.parseInt(mediador.getdAProvincia()));			
		}else{
			nDesfaseANumColTotal += 1;
		}
		pstmt.setString(12-nDesfaseANumColTotal, mediador.getdACodigoPostal());
		pstmt.setString(13-nDesfaseANumColTotal, mediador.getdATelefono());
		pstmt.setString(14-nDesfaseANumColTotal, mediador.getdAEMail());
		pstmt.setString(15-nDesfaseANumColTotal, mediador.getdAWeb());
    	String sUpdateNum = "";
    	if (mediador.getpSCapitalSocial()==null){
    		sUpdateNum = null;
    	}else if ("".equals(mediador.getpSCapitalSocial().trim())){
    		sUpdateNum = null;
    	}else{
//    		sUpdateNum = mediador.getpSCapitalSocial().replaceAll("\\.", "");
    		sUpdateNum = mediador.getpSCapitalSocial();
    	}
    	pstmt.setString(16-nDesfaseANumColTotal, sUpdateNum);
    	sUpdateNum = "";
    	if (mediador.getpSNumeroParticipaciones()==null){
    		sUpdateNum = null;
    	}else if ("".equals(mediador.getpSNumeroParticipaciones().trim())){
    		sUpdateNum = null;
    	}else{
    		sUpdateNum = mediador.getpSNumeroParticipaciones().replaceAll("\\.", "");
    	}
		pstmt.setString(17-nDesfaseANumColTotal, sUpdateNum);
		String tipoAtencionCliente = null;
		if (mediador.getaCTAtencioncliente()==null){
			tipoAtencionCliente = P06BConstantes.P06B_AC_NOPROCEDE;			
		}else{
			tipoAtencionCliente = mediador.getaCTAtencioncliente();
		}

		pstmt.setString(18-nDesfaseANumColTotal, tipoAtencionCliente);

		return pstmt;		
	}
	
	/**
	 */
	private PreparedStatement prepareCancelacionSQL(DatosMediadores mediador, P06B64T00Datatype p06B64T00Datatype) throws SQLException {

		StringBuilder sbsql = new StringBuilder();
		
		sbsql.append("UPDATE " + P06BTablas.P06B_P06B20T00_TABLA + " SET "); 
		sbsql.append(P06BTablas.P06B_P06B20_ESTADO); 
		sbsql.append(" = ?,");
		sbsql.append(P06BTablas.P06B_P06B20_FECHABAJ); 
		sbsql.append(" = SYSDATE,");
		sbsql.append(P06BTablas.P06B_P06B20_MOTIVOB); 
		sbsql.append(" = ?,");
		sbsql.append(P06BTablas.P06B_P06B20_ATENCPETICINCORPORADA); 
		sbsql.append(" = ?");
		sbsql.append(" WHERE ");
		sbsql.append(P06BTablas.P06B_P06B20_NUMEXP); 
		sbsql.append(" = ?");

		this.sql =  sbsql.toString();
		pstmt = con.prepareStatement(this.sql);
		
		int nDesfaseANumColTotal = 0;
		pstmt.setString(1, P06BConstantes.P06B_CORREDORES_ESTADO_PDTE_BAJA);
		pstmt.setString(2, mediador.getOtrosMotivos().substring(0, (mediador.getOtrosMotivos().length()>150)?150:mediador.getOtrosMotivos().length()));
		pstmt.setInt(3, p06B64T00Datatype.getCorrelativo());
		pstmt.setString(4, mediador.getExpedienteFormateado());

		return pstmt;		
	}
	
	/**
	 * Obtiene la SQL asociada al alta de una solicitud de reclamacin
	 * 
	 * @param solicitud
	 *            : Objeto de tipo AltaMediadores con los datos de negocio de la solicitud de reclamacin
	 *            a almacenar en base de datos
	 */
	private void getAlta26SQL(DatosMediadores mediador) {

		String altaTramitaguneSQL = "";
		
		altaTramitaguneSQL = "INSERT INTO P06B26T00_ATENCLIENTE (P06B26_NUMEXP,P06B26_IDENTIFICADOR,P06B26_TIPO,P06B26_CLASE,P06B26_RAZSOC,P06B26_NOMBRE,P06B26_APE1,P06B26_APE2)";

		StringBuilder sbValues = new StringBuilder("");
//		String sP06B26_NUMEXP = mediador.numExpediente();
		String sP06B26_NUMEXP = mediador.formatearExpediente();
		String sP06B26_IDENTIFICADOR = mediador.getaCTId();
		String sP06B26_TIPO = DatosMediadores.obtenerTipoPersonaEnBaseATipoIdTramitagune(mediador.getaCTTipoId());
		String sP06B26_CLASE = "I";
		sP06B26_CLASE = "E";
		sP06B26_CLASE = "?";
		sP06B26_CLASE = "I";
		String sP06B26_RAZSOC = "";
		String sP06B26_NOMBRE = "";
		String sP06B26_APE1 = "";
		String sP06B26_APE2 = "";
		if (sP06B26_TIPO.equals(P06BConstantes.P06B_PERSONA_FISICA)){
			sP06B26_NOMBRE = mediador.getaCTNombre();
			sP06B26_APE1 = mediador.getaCTApe1();
			sP06B26_APE2 = mediador.getaCTApe2();
		}else if (sP06B26_TIPO.equals(P06BConstantes.P06B_PERSONA_JURIDICA)){
			sP06B26_RAZSOC = mediador.getaCTNombre() + mediador.getaCTApe1() + mediador.getaCTApe2();
		}
		
		sbValues.append(" VALUES ");
		sbValues.append("(");
		sbValues.append(this.getStringValues(sP06B26_NUMEXP));
		sbValues.append(",");
		sbValues.append(this.getStringValues(sP06B26_IDENTIFICADOR));
		sbValues.append(",");
		sbValues.append(this.getStringValues(sP06B26_TIPO));
		sbValues.append(",");
		sbValues.append(this.getStringValues(sP06B26_CLASE));
		sbValues.append(",");
		sbValues.append(this.getStringValues(sP06B26_RAZSOC));
		sbValues.append(",");
		sbValues.append(this.getStringValues(sP06B26_NOMBRE));
		sbValues.append(",");
		sbValues.append(this.getStringValues(sP06B26_APE1));
		sbValues.append(",");
		sbValues.append(this.getStringValues(sP06B26_APE2));
		sbValues.append(")");
		
		this.sql =  altaTramitaguneSQL + " " + sbValues.toString();
	}

	/**
	 */
	private PreparedStatement prepareAlta76SQL(DatosMediadores mediador, P06B64T00Datatype p06B64T00Datatype) throws SQLException {

		StringBuilder alta76SQL = new StringBuilder();
		
		alta76SQL.append("INSERT INTO " + P06BTablas.P06B_P06B76T00_TABLA + " ("); 
		alta76SQL.append(P06BTablas.P06B_P06B76_AC_CORRELATENCPETIC); 
		alta76SQL.append(", ");
		alta76SQL.append(P06BTablas.P06B_P06B76_AC_NUMEXP); 
		alta76SQL.append(", ");
		alta76SQL.append(P06BTablas.P06B_P06B76_AC_IDENTIFICADOR); 
		alta76SQL.append(", ");
		alta76SQL.append(P06BTablas.P06B_P06B76_AC_TIPO); 
		String sTipoPersona = DatosMediadores.obtenerTipoPersonaEnBaseATipoIdTramitagune(mediador.getaCTTipoId());
		if (sTipoPersona.equals(P06BConstantes.P06B_PERSONA_JURIDICA)){
			alta76SQL.append(", ");
			alta76SQL.append(P06BTablas.P06B_P06B76_AC_RAZSOC); 
		}else{
			alta76SQL.append(", ");
			alta76SQL.append(P06BTablas.P06B_P06B76_AC_NOMBRE); 
			alta76SQL.append(", ");
			alta76SQL.append(P06BTablas.P06B_P06B76_AC_APE1); 
			alta76SQL.append(", ");
			alta76SQL.append(P06BTablas.P06B_P06B76_AC_APE2); 
		}
		alta76SQL.append(") VALUES (");
		alta76SQL.append("?");
		alta76SQL.append(", ?");
		alta76SQL.append(", ?");
		alta76SQL.append(", ?");
		if (sTipoPersona.equals(P06BConstantes.P06B_PERSONA_JURIDICA)){
			alta76SQL.append(", ?");
		}else{
			alta76SQL.append(", ?");
			alta76SQL.append(", ?");
			alta76SQL.append(", ?");
		}
		alta76SQL.append(")");

		this.sql =  alta76SQL.toString();
		pstmt = con.prepareStatement(this.sql);
		
		int nDesfaseANumColTotal = 0;
		pstmt.setInt(1, p06B64T00Datatype.getCorrelativo());
		pstmt.setString(2, mediador.formatearExpediente());
		pstmt.setString(3, mediador.getaCTId());
		pstmt.setString(4, sTipoPersona);
		if (sTipoPersona.equals(P06BConstantes.P06B_PERSONA_JURIDICA)){
			pstmt.setString(5, mediador.getaCTNombre() + mediador.getaCTApe1() + mediador.getaCTApe2());
			nDesfaseANumColTotal += 3;
		}else{
			pstmt.setString(5, mediador.getaCTNombre());
			pstmt.setString(6, mediador.getaCTApe1());
			pstmt.setString(7, mediador.getaCTApe2());
			nDesfaseANumColTotal += 1;
		}

		return pstmt;		
	}
	
	/**
	 * Obtiene la SQL asociada al alta de una solicitud de reclamacin
	 * 
	 * @param solicitud
	 *            : Objeto de tipo AltaMediadores con los datos de negocio de la solicitud de reclamacin
	 *            a almacenar en base de datos
	 */
	private void getAlta29SQL(DatosMediadores mediador) {

		String altaTramitaguneSQL = "";
		
		altaTramitaguneSQL = "INSERT INTO P06B29T00_DEFECLIENTE (P06B29_NUMEXP,P06B29_IDENTIFICADOR,P06B29_TIPO,P06B29_RAZSOC,P06B29_NOMBRE,P06B29_APE1,P06B29_APE2)";

		StringBuilder sbValues = new StringBuilder("");
//		String P06B29_NUMEXP = mediador.numExpediente();
		String P06B29_NUMEXP = mediador.formatearExpediente();
		String P06B29_IDENTIFICADOR = mediador.getaCDId();
		String P06B29_TIPO = DatosMediadores.obtenerTipoPersonaEnBaseATipoIdTramitagune(mediador.getaCDTipoId());
		String P06B29_RAZSOC = "";
		String P06B29_NOMBRE = "";
		String P06B29_APE1 = "";
		String P06B29_APE2 = "";
		if (P06B29_TIPO.equals(P06BConstantes.P06B_PERSONA_FISICA)){
			P06B29_NOMBRE = mediador.getaCDNombre();
			P06B29_APE1 = mediador.getaCDApe1();
			P06B29_APE2 = mediador.getaCDApe2();
		}else if (P06B29_TIPO.equals(P06BConstantes.P06B_PERSONA_JURIDICA)){
			P06B29_RAZSOC = mediador.getaCDNombre() + mediador.getaCDApe1() + mediador.getaCDApe2();
		}
		
		sbValues.append(" VALUES ");
		sbValues.append("(");
		sbValues.append(this.getStringValues(P06B29_NUMEXP));
		sbValues.append(",");
		sbValues.append(this.getStringValues(P06B29_IDENTIFICADOR));
		sbValues.append(",");
		sbValues.append(this.getStringValues(P06B29_TIPO));
		sbValues.append(",");
		sbValues.append(this.getStringValues(P06B29_RAZSOC));
		sbValues.append(",");
		sbValues.append(this.getStringValues(P06B29_NOMBRE));
		sbValues.append(",");
		sbValues.append(this.getStringValues(P06B29_APE1));
		sbValues.append(",");
		sbValues.append(this.getStringValues(P06B29_APE2));
		sbValues.append(")");
		
		this.sql =  altaTramitaguneSQL + " " + sbValues.toString();
	}
	
	
	
	/**
	 */
	private PreparedStatement prepareAlta79SQL(DatosMediadores mediador, P06B64T00Datatype p06B64T00Datatype) throws SQLException {

		StringBuilder alta79SQL = new StringBuilder();
		
		alta79SQL.append("INSERT INTO " + P06BTablas.P06B_P06B79T00_TABLA + " ("); 
		alta79SQL.append(P06BTablas.P06B_P06B79_DC_CORRELATENCPETIC); 
		alta79SQL.append(", ");
		alta79SQL.append(P06BTablas.P06B_P06B79_DC_NUMEXP); 
		alta79SQL.append(", ");
		alta79SQL.append(P06BTablas.P06B_P06B79_DC_IDENTIFICADOR); 
		alta79SQL.append(", ");
		alta79SQL.append(P06BTablas.P06B_P06B79_DC_TIPO); 
		String sTipoPersona = DatosMediadores.obtenerTipoPersonaEnBaseATipoIdTramitagune(mediador.getaCDTipoId());
		if (sTipoPersona.equals(P06BConstantes.P06B_PERSONA_JURIDICA)){
			alta79SQL.append(", ");
			alta79SQL.append(P06BTablas.P06B_P06B79_DC_RAZSOC); 
		}else{
			alta79SQL.append(", ");
			alta79SQL.append(P06BTablas.P06B_P06B79_DC_NOMBRE); 
			alta79SQL.append(", ");
			alta79SQL.append(P06BTablas.P06B_P06B79_DC_APE1); 
			alta79SQL.append(", ");
			alta79SQL.append(P06BTablas.P06B_P06B79_DC_APE2); 
		}
		alta79SQL.append(") VALUES (");
		alta79SQL.append("?");
		alta79SQL.append(", ?");
		alta79SQL.append(", ?");
		alta79SQL.append(", ?");
		if (sTipoPersona.equals(P06BConstantes.P06B_PERSONA_JURIDICA)){
			alta79SQL.append(", ?");
		}else{
			alta79SQL.append(", ?");
			alta79SQL.append(", ?");
			alta79SQL.append(", ?");
		}
		alta79SQL.append(")");

		this.sql =  alta79SQL.toString();
		pstmt = con.prepareStatement(this.sql);
		
		int nDesfaseANumColTotal = 0;
		pstmt.setInt(1, p06B64T00Datatype.getCorrelativo());
		pstmt.setString(2, mediador.formatearExpediente());
		pstmt.setString(3, mediador.getaCDId());
		pstmt.setString(4, sTipoPersona);
		if (sTipoPersona.equals(P06BConstantes.P06B_PERSONA_JURIDICA)){
			pstmt.setString(5, mediador.getaCDNombre() + mediador.getaCDApe1() + mediador.getaCDApe2());
			nDesfaseANumColTotal += 3;
		}else{
			pstmt.setString(5, mediador.getaCDNombre());
			pstmt.setString(6, mediador.getaCDApe1());
			pstmt.setString(7, mediador.getaCDApe2());
			nDesfaseANumColTotal += 1;
		}

		return pstmt;		
	}
	
	/**
	 * Obtiene la SQL asociada al alta de una solicitud de reclamacin
	 * 
	 * @param solicitud
	 *            : Objeto de tipo AltaMediadores con los datos de negocio de la solicitud de reclamacin
	 *            a almacenar en base de datos
	 */
	private PreparedStatement prepareAlta22SQL(P06B22T00Datatype p06B22T00Datatype, ContextSubmissionEvent cData) throws SQLException {

		String altaTramitaguneSQL = "";
		
		altaTramitaguneSQL = "INSERT INTO P06B22T00_SOCIOSEXP (P06B22_TIPO,P06B22_NUMEXP,P06B22_IDENTIFICADOR,P06B22_TIPO1,P06B22_RAZSOC,P06B22_NOMBRE,P06B22_APE1,P06B22_APE2,P06B22_FECALTA,P06B22_PARTICIPA,P06B22_IDREP,P06B22_NOMREP)";

		StringBuilder sbValues = new StringBuilder("");
		sbValues.append("INSERT INTO " + P06BTablas.P06B_P06B22T00_TABLA + " ("); 
		sbValues.append(P06BTablas.P06B_P06B22_TIPO); 
		sbValues.append(", ");
		sbValues.append(P06BTablas.P06B_P06B22_NUMEXP); 
		sbValues.append(", ");
		sbValues.append(P06BTablas.P06B_P06B22_IDENTIFICADOR); 
		sbValues.append(", ");
		sbValues.append(P06BTablas.P06B_P06B22_TIPO1); 
		if (p06B22T00Datatype.getTipo1().equals(P06BConstantes.P06B_PERSONA_JURIDICA)){
			sbValues.append(", ");
			sbValues.append(P06BTablas.P06B_P06B22_RAZSOC); 
		}else if (p06B22T00Datatype.getTipo1().equals(P06BConstantes.P06B_PERSONA_FISICA)){
			sbValues.append(", ");
			sbValues.append(P06BTablas.P06B_P06B22_NOMBRE); 
			sbValues.append(", ");
			sbValues.append(P06BTablas.P06B_P06B22_APE1); 
			sbValues.append(", ");
			sbValues.append(P06BTablas.P06B_P06B22_APE2); 
		}
		sbValues.append(", ");
		sbValues.append(P06BTablas.P06B_P06B22_FECALTA); 
		sbValues.append(", ");
		sbValues.append(P06BTablas.P06B_P06B22_PARTICIPA); 
		if (p06B22T00Datatype.getTipo1().equals(P06BConstantes.P06B_PERSONA_JURIDICA)){
			sbValues.append(", ");
			sbValues.append(P06BTablas.P06B_P06B22_IDREP); 
			sbValues.append(", ");
			sbValues.append(P06BTablas.P06B_P06B22_NOMREP); 
		}
		sbValues.append(") VALUES (");
		sbValues.append("?");
		sbValues.append(", ?");
		sbValues.append(", ?");
		sbValues.append(", ?");
		if (p06B22T00Datatype.getTipo1().equals(P06BConstantes.P06B_PERSONA_JURIDICA)){
			sbValues.append(", ?");
		}else if (p06B22T00Datatype.getTipo1().equals(P06BConstantes.P06B_PERSONA_FISICA)){
			sbValues.append(", ?");
			sbValues.append(", ?");
			sbValues.append(", ?");
		}
		if (p06B22T00Datatype.getFecAlta().charAt(2)=='/'){
			sbValues.append(", TO_DATE(?,'DD/MM/YYYY')");
		}else{
			sbValues.append(", TO_DATE(?,'YYYY/MM/DD')");
		}
		sbValues.append(", ?");
		if (p06B22T00Datatype.getTipo1().equals(P06BConstantes.P06B_PERSONA_JURIDICA)){
			sbValues.append(", ?");
			sbValues.append(", ?");
		}
		sbValues.append(")");
		this.sql =  sbValues.toString();
		pstmt = con.prepareStatement(this.sql);
		
		int nDesfaseANumColTotal = 0;
		pstmt.setString(1, p06B22T00Datatype.getTipo());
		pstmt.setString(2, p06B22T00Datatype.getNExpediente());
		pstmt.setString(3, p06B22T00Datatype.getIdentificador());
		pstmt.setString(4, p06B22T00Datatype.getTipo1());
		if (p06B22T00Datatype.getTipo1().equals(P06BConstantes.P06B_PERSONA_JURIDICA)){
			pstmt.setString(5, p06B22T00Datatype.getRazSoc());
			nDesfaseANumColTotal += 2;
		}else if (p06B22T00Datatype.getTipo1().equals(P06BConstantes.P06B_PERSONA_FISICA)){
			pstmt.setString(5, p06B22T00Datatype.getNombre());
			pstmt.setString(6, p06B22T00Datatype.getApe1());
			pstmt.setString(7, p06B22T00Datatype.getApe2());
		}
		pstmt.setString(8-nDesfaseANumColTotal, p06B22T00Datatype.getFecAlta());
		pstmt.setString(9-nDesfaseANumColTotal, p06B22T00Datatype.getParticipa());
		if (p06B22T00Datatype.getTipo1().equals(P06BConstantes.P06B_PERSONA_JURIDICA)){
			pstmt.setString(10-nDesfaseANumColTotal, p06B22T00Datatype.getIdRep());
			pstmt.setString(11-nDesfaseANumColTotal, p06B22T00Datatype.getNomRep());
		}

		return pstmt;		

		
//		String P06B22_TIPO = "";
//		String P06B22_NUMEXP = "";
//		String P06B22_IDENTIFICADOR = "";
//		String P06B22_TIPO1 = "";
//		String P06B22_RAZSOC = "";
//		String P06B22_NOMBRE = "";
//		String P06B22_APE1 = "";
//		String P06B22_APE2 = "";
//		String P06B22_FECALTA = "";
//		String P06B22_PARTICIPA = "";
//		String P06B22_IDREP = "";
//		String P06B22_NOMREP = "";
//		P06B22_TIPO = p06B22T00Datatype.getTipo();
//		P06B22_NUMEXP = p06B22T00Datatype.getNExpediente();
//		P06B22_IDENTIFICADOR = p06B22T00Datatype.getIdentificador(); 
//		P06B22_TIPO1 = p06B22T00Datatype.getTipo1();
//		if (P06B22_TIPO1.equals(P06BConstantes.P06B_PERSONA_JURIDICA)){
//			P06B22_RAZSOC = p06B22T00Datatype.getRazSoc();
//			P06B22_IDREP = p06B22T00Datatype.getIdRep();
//			P06B22_NOMREP = p06B22T00Datatype.getNomRep();
//		}else if (P06B22_TIPO1.equals(P06BConstantes.P06B_PERSONA_FISICA)){
//			P06B22_NOMBRE = p06B22T00Datatype.getNombre();
//			P06B22_APE1 = p06B22T00Datatype.getApe1();
//			P06B22_APE2 = p06B22T00Datatype.getApe2();
//		}
//		if (p06B22T00Datatype.getFecAlta().charAt(2)=='/'){
//			P06B22_FECALTA = "TO_DATE(" + this.getStringValues(p06B22T00Datatype.getFecAlta()) + ",'DD/MM/YYYY')";			
//		}else{
//			P06B22_FECALTA = "TO_DATE(" + this.getStringValues(p06B22T00Datatype.getFecAlta()) + ",'YYYY/MM/DD')";						
//		}
//		P06B22_PARTICIPA = p06B22T00Datatype.getParticipa();
//
//		sbValues.append(" VALUES ");
//		sbValues.append("(");
//		sbValues.append(P06B22_TIPO);
//		sbValues.append(",");
//		sbValues.append(this.getStringValues(P06B22_NUMEXP));
//		sbValues.append(",");
//		sbValues.append(this.getStringValues(P06B22_IDENTIFICADOR));
//		sbValues.append(",");
//		sbValues.append(this.getStringValues(P06B22_TIPO1));
//		sbValues.append(",");
//		sbValues.append(this.getStringValues(P06B22_RAZSOC));
//		sbValues.append(",");
//		sbValues.append(this.getStringValues(P06B22_NOMBRE));
//		sbValues.append(",");
//		sbValues.append(this.getStringValues(P06B22_APE1));
//		sbValues.append(",");
//		sbValues.append(this.getStringValues(P06B22_APE2));
//		sbValues.append(",");
//		sbValues.append(P06B22_FECALTA);
//		sbValues.append(",");
//		sbValues.append(P06B22_PARTICIPA);
//		sbValues.append(",");
//		sbValues.append(this.getStringValues(P06B22_IDREP));
//		sbValues.append(",");
//		sbValues.append(this.getStringValues(P06B22_NOMREP));
//		sbValues.append(")");
//				
//		this.sql =  altaTramitaguneSQL + " " + sbValues.toString();
	}
	
	
	
	/**
	 */
	private PreparedStatement prepareAlta72SQL(P06B22T00Datatype p06B22T00Datatype, P06B64T00Datatype p06B64T00Datatype, ContextSubmissionEvent cData) throws SQLException {

		StringBuilder alta72SQL = new StringBuilder();
		
		alta72SQL.append("INSERT INTO " + P06BTablas.P06B_P06B72T00_TABLA + " ("); 
		alta72SQL.append(P06BTablas.P06B_P06B72_SC_CORRELATENCPETIC); 
		alta72SQL.append(", ");
		alta72SQL.append(P06BTablas.P06B_P06B72_SC_TIPO); 
		alta72SQL.append(", ");
		alta72SQL.append(P06BTablas.P06B_P06B72_SC_NUMEXP); 
		alta72SQL.append(", ");
		alta72SQL.append(P06BTablas.P06B_P06B72_SC_IDENTIFICADOR); 
		alta72SQL.append(", ");
		alta72SQL.append(P06BTablas.P06B_P06B72_SC_TIPO1); 
		String sTipoPersona = p06B22T00Datatype.getTipo1();
		if (sTipoPersona.equals(P06BConstantes.P06B_PERSONA_JURIDICA)){
			alta72SQL.append(", ");
			alta72SQL.append(P06BTablas.P06B_P06B72_SC_RAZSOC); 
		}else{
			alta72SQL.append(", ");
			alta72SQL.append(P06BTablas.P06B_P06B72_SC_NOMBRE); 
			alta72SQL.append(", ");
			alta72SQL.append(P06BTablas.P06B_P06B72_SC_APE1); 
			alta72SQL.append(", ");
			alta72SQL.append(P06BTablas.P06B_P06B72_SC_APE2); 
		}
		alta72SQL.append(", ");
		alta72SQL.append(P06BTablas.P06B_P06B72_SC_FECALTA); 
		alta72SQL.append(", ");
		alta72SQL.append(P06BTablas.P06B_P06B72_SC_PARTICIPA); 
		if (sTipoPersona.equals(P06BConstantes.P06B_PERSONA_JURIDICA)){
			alta72SQL.append(", ");
			alta72SQL.append(P06BTablas.P06B_P06B72_SC_IDREP); 
			alta72SQL.append(", ");
			alta72SQL.append(P06BTablas.P06B_P06B72_SC_NOMREP); 			
		}
		alta72SQL.append(") VALUES (");
		alta72SQL.append("?");
		alta72SQL.append(", ?");
		alta72SQL.append(", ?");
		alta72SQL.append(", ?");
		alta72SQL.append(", ?");
		if (sTipoPersona.equals(P06BConstantes.P06B_PERSONA_JURIDICA)){
			alta72SQL.append(", ?");
		}else{
			alta72SQL.append(", ?");
			alta72SQL.append(", ?");
			alta72SQL.append(", ?");
		}
//		if (cData.getApplicantsInfoEvent().getApplicantInfoEvent().get(0).getLanguage().equals("es")){
//			alta72SQL.append(", TO_DATE(?,'DD/MM/YYYY')");
//		}else{
//			alta72SQL.append(", TO_DATE(?,'YYYY/MM/DD')");
//		}
		if (p06B22T00Datatype.getFecAlta().charAt(2)=='/'){
			alta72SQL.append(", TO_DATE(?,'DD/MM/YYYY')");
		}else{
			alta72SQL.append(", TO_DATE(?,'YYYY/MM/DD')");
		}
		alta72SQL.append(", ?");
		if (sTipoPersona.equals(P06BConstantes.P06B_PERSONA_JURIDICA)){
			alta72SQL.append(", ?");
			alta72SQL.append(", ?");			
		}
		alta72SQL.append(")");

		this.sql =  alta72SQL.toString();
		pstmt = con.prepareStatement(this.sql);
		
		pstmt.setInt(1, p06B64T00Datatype.getCorrelativo());
		pstmt.setInt(2, Integer.parseInt(p06B22T00Datatype.getTipo()));
		pstmt.setString(3, p06B22T00Datatype.getNExpediente());
		pstmt.setString(4, p06B22T00Datatype.getIdentificador());
		pstmt.setString(5, p06B22T00Datatype.getTipo1());
		int nDesfaseANumColTotal = 0;
		if (sTipoPersona.equals(P06BConstantes.P06B_PERSONA_JURIDICA)){
			pstmt.setString(6, p06B22T00Datatype.getRazSoc());
			nDesfaseANumColTotal += 2;
		}else{
			pstmt.setString(6, p06B22T00Datatype.getNombre());
			pstmt.setString(7, p06B22T00Datatype.getApe1());
			pstmt.setString(8, p06B22T00Datatype.getApe2());
		}
		pstmt.setString(9-nDesfaseANumColTotal, p06B22T00Datatype.getFecAlta());
//		pstmt.setDouble(10-nDesfaseANumColTotal, Double.parseDouble(p06B22T00Datatype.getParticipa()));
		pstmt.setString(10-nDesfaseANumColTotal, p06B22T00Datatype.getParticipa());
		if (sTipoPersona.equals(P06BConstantes.P06B_PERSONA_JURIDICA)){
			pstmt.setString(11-nDesfaseANumColTotal, p06B22T00Datatype.getIdRep());
			pstmt.setString(12-nDesfaseANumColTotal, p06B22T00Datatype.getNomRep());
		}

		return pstmt;		
	}
	
	/**
	 * Obtiene la SQL asociada al alta de una solicitud de reclamacin
	 * 
	 * @param solicitud
	 *            : Objeto de tipo AltaMediadores con los datos de negocio de la solicitud de reclamacin
	 *            a almacenar en base de datos
	 */
	private void getAlta24ODSQL(P06B24T00Datatype p06B24T00Datatype, ContextSubmissionEvent cData) {

		String altaTramitaguneSQL = "";
		
//		altaTramitaguneSQL = "INSERT INTO P06B24T00_ORGANOSDIREXP (P06B24_TIPO,P06B24_NUMEXP,P06B24_IDENTIFICADOR,P06B24_NOMBRE,P06B24_APE1,P06B24_APE2,P06B24_CURSO,P06B24_DENCURSO,P06B24_FECHNOM,P06B24_ACREDITAH,P06B24_IDCARGO,P06B24_DENCARGO,P06B24_TIPO1,P06B24_RAZSOC,P06B24_PAIS,P06B24_PROFESI)";
//		altaTramitaguneSQL = "INSERT INTO P06B24T00_ORGANOSDIREXP (P06B24_TIPO,P06B24_NUMEXP,P06B24_IDENTIFICADOR,P06B24_NOMBRE,P06B24_APE1,P06B24_APE2,P06B24_CURSO,P06B24_DENCURSO,P06B24_FECHNOM,P06B24_ACREDITAH,P06B24_IDCARGO,                P06B24_TIPO1,P06B24_RAZSOC,P06B24_PAIS,P06B24_PROFESI)";
//		altaTramitaguneSQL = "INSERT INTO P06B24T00_ORGANOSDIREXP (P06B24_TIPO,P06B24_NUMEXP,P06B24_IDENTIFICADOR,P06B24_NOMBRE,P06B24_APE1,P06B24_APE2,P06B24_CURSO,P06B24_DENCURSO,P06B24_FECHNOM,P06B24_ACREDITAH,P06B24_IDCARGO,                             P06B24_RAZSOC,P06B24_PAIS,P06B24_PROFESI)";
		altaTramitaguneSQL = "INSERT INTO P06B24T00_ORGANOSDIREXP (P06B24_TIPO,P06B24_NUMEXP,P06B24_IDENTIFICADOR,P06B24_NOMBRE,P06B24_APE1,P06B24_APE2,P06B24_CURSO,P06B24_DENCURSO,P06B24_FECHNOM,P06B24_ACREDITAH,P06B24_IDCARGO,                                           P06B24_PAIS,P06B24_PROFESI)";

		StringBuilder sbValues = new StringBuilder("");
		String P06B24_TIPO = "";
		String P06B24_NUMEXP = "";
		String P06B24_IDENTIFICADOR = "";
		String P06B24_NOMBRE = "";
		String P06B24_APE1 = "";
		String P06B24_APE2 = "";
		String P06B24_CURSO = "";
		String P06B24_DENCURSO = "";
		String P06B24_FECHNOM = "";
		String P06B24_ACREDITAH = "";
		String P06B24_IDCARGO = "";
//		String P06B24_DENCARGO = "";
//		String P06B24_TIPO1 = "";
//		String P06B24_RAZSOC = "";
		String P06B24_PAIS = "";
		String P06B24_PROFESI = "";
		P06B24_TIPO = p06B24T00Datatype.getTipo();
		P06B24_NUMEXP = p06B24T00Datatype.getnExpediente();
		P06B24_IDENTIFICADOR = p06B24T00Datatype.getIdentificador(); 
		if (P06B24_NOMBRE.length()>50){
			P06B24_NOMBRE = p06B24T00Datatype.getNombre().substring(0, 50);
		}else{
			P06B24_NOMBRE = p06B24T00Datatype.getNombre();
		}
		P06B24_APE1 = p06B24T00Datatype.getApe1();
		P06B24_APE2 = p06B24T00Datatype.getApe2();
		P06B24_CURSO = p06B24T00Datatype.getCurso(); 
		P06B24_DENCURSO = p06B24T00Datatype.getDenCurso();
//		if (cData.getApplicantsInfoEvent().getApplicantInfoEvent().get(0).getLanguage().equals("es")){
//			P06B24_FECHNOM = "TO_DATE(" + this.getStringValues(p06B24T00Datatype.getFechNom()) + ",'DD/MM/YYYY')";
//		}else{
//			P06B24_FECHNOM = "TO_DATE(" + this.getStringValues(p06B24T00Datatype.getFechNom()) + ",'YYYY/MM/DD')";
//		}
		if (p06B24T00Datatype.getFechNom().charAt(2)=='/'){
			P06B24_FECHNOM = "TO_DATE(" + this.getStringValues(p06B24T00Datatype.getFechNom()) + ",'DD/MM/YYYY')";
		}else{
			P06B24_FECHNOM = "TO_DATE(" + this.getStringValues(p06B24T00Datatype.getFechNom()) + ",'YYYY/MM/DD')";
		}
		P06B24_ACREDITAH = p06B24T00Datatype.getAcreditaH();
		P06B24_IDCARGO = p06B24T00Datatype.getIdCargo();			
//		if (P06B24_DENCARGO.length()>100){
//			P06B24_DENCARGO = p06B24T00Datatype.getDenCargo().substring(0, 100);
//		}else{
//			P06B24_DENCARGO = p06B24T00Datatype.getDenCargo();
//		}
//		P06B24_TIPO1 = p06B24T00Datatype.getTipo1();
//		if (p06B24T00Datatype.getRazSoc().length()>150){
//			P06B24_RAZSOC = p06B24T00Datatype.getRazSoc().substring(0, 150);			
//		}else{
//			P06B24_RAZSOC = p06B24T00Datatype.getRazSoc();			
//		}
		P06B24_PAIS = p06B24T00Datatype.getPais();
		if (p06B24T00Datatype.getProfesi().length()>50){
			P06B24_PROFESI = p06B24T00Datatype.getProfesi().substring(0, 50);
		}else{
			P06B24_PROFESI = p06B24T00Datatype.getProfesi();
		}

		sbValues.append(" VALUES ");
		sbValues.append("(");
		sbValues.append(P06B24_TIPO);
		sbValues.append(",");
		sbValues.append(this.getStringValues(P06B24_NUMEXP));
		sbValues.append(",");
		sbValues.append(this.getStringValues(P06B24_IDENTIFICADOR));
		sbValues.append(",");
		sbValues.append(this.getStringValues(P06B24_NOMBRE));
		sbValues.append(",");
		sbValues.append(this.getStringValues(P06B24_APE1));
		sbValues.append(",");
		sbValues.append(this.getStringValues(P06B24_APE2));
		sbValues.append(",");
		sbValues.append(this.getStringValues(P06B24_CURSO));
		sbValues.append(",");
		sbValues.append(this.getStringValues(P06B24_DENCURSO));
		sbValues.append(",");
		sbValues.append(P06B24_FECHNOM);
		sbValues.append(",");
		sbValues.append(this.getStringValues(P06B24_ACREDITAH));
		sbValues.append(",");
		sbValues.append(this.getStringValues(P06B24_IDCARGO));
		sbValues.append(",");
//		sbValues.append(this.getStringValues(P06B24_DENCARGO));
//		sbValues.append(",");
//		sbValues.append(this.getStringValues(P06B24_TIPO1));
//		sbValues.append(",");
//		sbValues.append(this.getStringValues(P06B24_RAZSOC));
//		sbValues.append(",");
/*		if (P06B24_PAIS==null || P06B24_PAIS.equals("")){
			sbValues.append(P06B24_PAIS);			
		}else{
			sbValues.append(Byte.parseByte(P06B24_PAIS));			
		}*/
		sbValues.append(this.getStringValues(P06B24_PAIS));			
		sbValues.append(",");
		sbValues.append(this.getStringValues(P06B24_PROFESI));
		sbValues.append(")");
				
		this.sql =  altaTramitaguneSQL + " " + sbValues.toString();
	}
	
	
	
	/**
	 */
	private PreparedStatement prepareAlta74AcreditacionParticipantesSQL(P06B24T00Datatype p06B24T00Datatype, P06B64T00Datatype p06B64T00Datatype, ContextSubmissionEvent cData) throws SQLException {

		StringBuilder alta74ODSQL = new StringBuilder();
		
		alta74ODSQL.append("INSERT INTO " + P06BTablas.P06B_P06B74T00_TABLA + " ("); 
		alta74ODSQL.append(P06BTablas.P06B_P06B74_OD_CORRELATENCPETIC); 
		alta74ODSQL.append(", ");
		alta74ODSQL.append(P06BTablas.P06B_P06B74_OD_TIPO); 
		alta74ODSQL.append(", ");
		alta74ODSQL.append(P06BTablas.P06B_P06B74_OD_NUMEXP); 
		alta74ODSQL.append(", ");
		alta74ODSQL.append(P06BTablas.P06B_P06B74_OD_IDENTIFICADOR); 
		alta74ODSQL.append(", ");
//		alta74ODSQL.append(P06BTablas.P06B_P06B74_OD_TIPO1); 
//		alta74ODSQL.append(", ");
		alta74ODSQL.append(P06BTablas.P06B_P06B74_OD_NOMBRE); 
		alta74ODSQL.append(", ");
		alta74ODSQL.append(P06BTablas.P06B_P06B74_OD_FECHNOM); 
		alta74ODSQL.append(", ");
		alta74ODSQL.append(P06BTablas.P06B_P06B74_OD_IDCARGO); 
		if (p06B24T00Datatype.getTipo().equals(P06BConstantes.P06B_CARGOS_ORGANODIRECCIONRESPONSABLE)){
			alta74ODSQL.append(", ");
			alta74ODSQL.append(P06BTablas.P06B_P06B74_OD_IDCURSO); 
			alta74ODSQL.append(", ");
			alta74ODSQL.append(P06BTablas.P06B_P06B74_OD_DENCURSO); 			
		}
//		if (p06B24T00Datatype.getTipo().equals(P06BConstantes.P06B_CARGOS_ADMINISTRADOR)){
//			if (p06B24T00Datatype.getTipo1().equals(P06BConstantes.P06B_PERSONA_JURIDICA)){
//				alta74ODSQL.append(", ");
//				alta74ODSQL.append(P06BTablas.P06B_P06B74_OD_IDREP); 
//				alta74ODSQL.append(", ");
//				alta74ODSQL.append(P06BTablas.P06B_P06B74_OD_NOMREP); 
//			}			
//		}
		alta74ODSQL.append(") VALUES (");
		alta74ODSQL.append("?");
		alta74ODSQL.append(", ?");
		alta74ODSQL.append(", ?");
		alta74ODSQL.append(", ?");
//		alta74ODSQL.append(", ?");
		alta74ODSQL.append(", ?");
//		if (cData.getApplicantsInfoEvent().getApplicantInfoEvent().get(0).getLanguage().equals("es")){
//			alta74ODSQL.append(", TO_DATE(?,'DD/MM/YYYY')");
//		}else{
//			alta74ODSQL.append(", TO_DATE(?,'YYYY/MM/DD')");
//		}
		if (p06B24T00Datatype.getFechNom().charAt(2)=='/'){
			alta74ODSQL.append(", TO_DATE(?,'DD/MM/YYYY')");
		}else{
			alta74ODSQL.append(", TO_DATE(?,'YYYY/MM/DD')");
		}
		alta74ODSQL.append(", ?");
		if (p06B24T00Datatype.getTipo().equals(P06BConstantes.P06B_CARGOS_ORGANODIRECCIONRESPONSABLE)){
			alta74ODSQL.append(", ?");
			alta74ODSQL.append(", ?");			
		}
//		if (p06B24T00Datatype.getTipo().equals(P06BConstantes.P06B_CARGOS_ADMINISTRADOR)){
//			if (p06B24T00Datatype.getTipo1().equals(P06BConstantes.P06B_PERSONA_JURIDICA)){
//				alta74ODSQL.append(", ?");
//				alta74ODSQL.append(", ?");			
//			}			
//		}
		alta74ODSQL.append(")");

		this.sql =  alta74ODSQL.toString();
		pstmt = con.prepareStatement(this.sql);
		
		int nDesfaseANumColTotal = 0;
		pstmt.setInt(1, p06B64T00Datatype.getCorrelativo());
		pstmt.setInt(2, Integer.parseInt(p06B24T00Datatype.getTipo()));
		pstmt.setString(3, p06B24T00Datatype.getnExpediente());
		pstmt.setString(4, p06B24T00Datatype.getIdentificador());
//		pstmt.setString(5, p06B24T00Datatype.getTipo1());
		pstmt.setString(5, p06B24T00Datatype.getNombre());
		pstmt.setString(6, p06B24T00Datatype.getFechNom());
		pstmt.setString(7, p06B24T00Datatype.getIdCargo());
		if (p06B24T00Datatype.getTipo().equals(P06BConstantes.P06B_CARGOS_ORGANODIRECCIONRESPONSABLE)){
			pstmt.setString(8, p06B24T00Datatype.getCurso());
			pstmt.setString(9, p06B24T00Datatype.getDenCurso());			
		}else{
			nDesfaseANumColTotal += 2;
		}
//		if (p06B24T00Datatype.getTipo().equals(P06BConstantes.P06B_CARGOS_ADMINISTRADOR)){
//			if (p06B24T00Datatype.getTipo1().equals(P06BConstantes.P06B_PERSONA_JURIDICA)){
//				pstmt.setString(11-nDesfaseANumColTotal, p06B24T00Datatype.getIdRep());
//				pstmt.setString(12-nDesfaseANumColTotal, p06B24T00Datatype.getNomRep());			
//			}else{
//				nDesfaseANumColTotal += 2;
//			}			
//		}else{
//			nDesfaseANumColTotal += 2;
//		}

		return pstmt;		
	}
	
	/**
	 */
	/**
	 * Obtiene la SQL asociada al alta de una solicitud de reclamacin
	 * 
	 * @param solicitud
	 *            : Objeto de tipo AltaMediadores con los datos de negocio de la solicitud de reclamacin
	 *            a almacenar en base de datos
	 */
	private void getAlta24ASQL(P06B24T00Datatype p06B24T00Datatype, ContextSubmissionEvent cData) {

		String altaTramitaguneSQL = "";
		
//		altaTramitaguneSQL = "INSERT INTO P06B24T00_ORGANOSDIREXP (P06B24_TIPO,P06B24_NUMEXP,P06B24_IDENTIFICADOR,P06B24_NOMBRE,P06B24_APE1,P06B24_APE2,P06B24_FECHNOM,P06B24_ACREDITAH,P06B24_IDCARGO,P06B24_DENCARGO,P06B24_IDREP,P06B24_NOMREP,P06B24_TIPO1,P06B24_RAZSOC)";
//		altaTramitaguneSQL = "INSERT INTO P06B24T00_ORGANOSDIREXP (P06B24_TIPO,P06B24_NUMEXP,P06B24_IDENTIFICADOR,P06B24_NOMBRE,P06B24_APE1,P06B24_APE2,P06B24_FECHNOM,P06B24_ACREDITAH,P06B24_IDCARGO,                P06B24_IDREP,P06B24_NOMREP,P06B24_TIPO1,P06B24_RAZSOC)";
//		altaTramitaguneSQL = "INSERT INTO P06B24T00_ORGANOSDIREXP (P06B24_TIPO,P06B24_NUMEXP,P06B24_IDENTIFICADOR,P06B24_NOMBRE,P06B24_APE1,P06B24_APE2,P06B24_FECHNOM,P06B24_ACREDITAH,P06B24_IDCARGO,                                           P06B24_TIPO1,P06B24_RAZSOC)";
		altaTramitaguneSQL = "INSERT INTO P06B24T00_ORGANOSDIREXP (P06B24_TIPO,P06B24_NUMEXP,P06B24_IDENTIFICADOR,P06B24_NOMBRE,P06B24_APE1,P06B24_APE2,P06B24_FECHNOM,P06B24_ACREDITAH,P06B24_IDCARGO                                                                      )";

		StringBuilder sbValues = new StringBuilder("");
		String P06B24_TIPO = "";
		String P06B24_NUMEXP = "";
		String P06B24_IDENTIFICADOR = "";
		String P06B24_NOMBRE = "";
		String P06B24_APE1 = "";
		String P06B24_APE2 = "";
		String P06B24_FECHNOM = "";
		String P06B24_ACREDITAH = "";
		String P06B24_IDCARGO = "";
//		String P06B24_DENCARGO = "";
//		String P06B24_IDREP = "";
//		String P06B24_NOMREP = "";
//		String P06B24_TIPO1 = "";
//		String P06B24_RAZSOC = "";
		P06B24_TIPO = p06B24T00Datatype.getTipo();
		P06B24_NUMEXP = p06B24T00Datatype.getnExpediente();
		P06B24_IDENTIFICADOR = p06B24T00Datatype.getIdentificador(); 
		P06B24_NOMBRE = p06B24T00Datatype.getNombre();
		if (P06B24_NOMBRE.length()>50){
			P06B24_NOMBRE = P06B24_NOMBRE.substring(0, 50);
		}
		P06B24_APE1 = p06B24T00Datatype.getApe1();
		P06B24_APE2 = p06B24T00Datatype.getApe2();
//		if (cData.getApplicantsInfoEvent().getApplicantInfoEvent().get(0).getLanguage().equals("es")){
//			P06B24_FECHNOM = "TO_DATE(" + this.getStringValues(p06B24T00Datatype.getFechNom()) + ",'DD/MM/YYYY')";
//		}else{
//			P06B24_FECHNOM = "TO_DATE(" + this.getStringValues(p06B24T00Datatype.getFechNom()) + ",'YYYY/MM/DD')";
//		}
		if (p06B24T00Datatype.getFechNom().charAt(2)=='/'){
			P06B24_FECHNOM = "TO_DATE(" + this.getStringValues(p06B24T00Datatype.getFechNom()) + ",'DD/MM/YYYY')";
		}else{
			P06B24_FECHNOM = "TO_DATE(" + this.getStringValues(p06B24T00Datatype.getFechNom()) + ",'YYYY/MM/DD')";
		}
		P06B24_ACREDITAH = p06B24T00Datatype.getAcreditaH();
		P06B24_IDCARGO = p06B24T00Datatype.getIdCargo();			
//		P06B24_DENCARGO = p06B24T00Datatype.getDenCargo();
//		P06B24_IDREP = p06B24T00Datatype.getIdRep();
//		P06B24_NOMREP = p06B24T00Datatype.getNomRep();
//		P06B24_TIPO1 = p06B24T00Datatype.getTipo1();
//		P06B24_RAZSOC = p06B24T00Datatype.getRazSoc();

		sbValues.append(" VALUES ");
		sbValues.append("(");
		sbValues.append(P06B24_TIPO);
		sbValues.append(",");
		sbValues.append(this.getStringValues(P06B24_NUMEXP));
		sbValues.append(",");
		sbValues.append(this.getStringValues(P06B24_IDENTIFICADOR));
		sbValues.append(",");
		sbValues.append(this.getStringValues(P06B24_NOMBRE));
		sbValues.append(",");
		sbValues.append(this.getStringValues(P06B24_APE1));
		sbValues.append(",");
		sbValues.append(this.getStringValues(P06B24_APE2));
		sbValues.append(",");
		sbValues.append(P06B24_FECHNOM);
		sbValues.append(",");
		sbValues.append(this.getStringValues(P06B24_ACREDITAH));
		sbValues.append(",");
		sbValues.append(this.getStringValues(P06B24_IDCARGO));
//		sbValues.append(",");
//		sbValues.append(this.getStringValues(P06B24_DENCARGO));
//		sbValues.append(",");
//		sbValues.append(this.getStringValues(P06B24_IDREP));
//		sbValues.append(",");
//		sbValues.append(this.getStringValues(P06B24_NOMREP));
//		sbValues.append(",");
//		sbValues.append(this.getStringValues(P06B24_TIPO1));
//		sbValues.append(",");
//		sbValues.append(this.getStringValues(P06B24_RAZSOC));
		sbValues.append(")");
				
		this.sql =  altaTramitaguneSQL + " " + sbValues.toString();
	}
	
	
	
	/**
	 * Obtiene la SQL asociada al alta de una solicitud de reclamacin
	 * 
	 * @param solicitud
	 *            : Objeto de tipo AltaMediadores con los datos de negocio de la solicitud de reclamacin
	 *            a almacenar en base de datos
	 */
	private void getAlta61SQL(P06B61T00Datatype p06B61T00Datatype) {

		String altaTramitaguneSQL = "";
		
		altaTramitaguneSQL = "INSERT INTO P06B61T00_ENT_VINCULADAS (P06B61_EV_NUMEXP,P06B61_EV_CIF,P06B61_EV_ENTIDAD,P06B61_EV_CALLE,P06B61_EV_PORTAL,P06B61_EV_PISO,P06B61_EV_LETRA,P06B61_EV_CODPRO,P06B61_EV_CODMUN,P06B61_EV_LOCALID,P06B61_EV_CODPST,P06B61_EV_CLAVECAT)";

		StringBuilder sbValues = new StringBuilder("");
		String P06B61_EV_NUMEXP = "";
		String P06B61_EV_CIF = "";
		String P06B61_EV_ENTIDAD = "";
		String P06B61_EV_CALLE = "";
		String P06B61_EV_PORTAL = "";
		String P06B61_EV_PISO = "";
		String P06B61_EV_LETRA = "";
		String P06B61_EV_CODPRO = "";
		String P06B61_EV_CODMUN = "";
		String P06B61_EV_LOCALID = "";
		String P06B61_EV_CODPST = "";
		String P06B61_EV_CLAVECAT = "";
		P06B61_EV_NUMEXP = p06B61T00Datatype.getExpedi();
		P06B61_EV_CIF = p06B61T00Datatype.getCif();
		P06B61_EV_ENTIDAD = p06B61T00Datatype.getEntidad(); 
//		P06B61_EV_CALLE = p06B61T00Datatype.getCalle();
//		P06B61_EV_PORTAL = p06B61T00Datatype.getPortal();
//		P06B61_EV_PISO = p06B61T00Datatype.getPiso(); 
//		P06B61_EV_LETRA = p06B61T00Datatype.getLetra();
//		P06B61_EV_CODPRO = p06B61T00Datatype.getCodpro();
//		P06B61_EV_CODMUN = p06B61T00Datatype.getCodmun();
//		P06B61_EV_LOCALID = p06B61T00Datatype.getLocali();
//		P06B61_EV_CODPST = p06B61T00Datatype.getCodpst();
		P06B61_EV_CLAVECAT = p06B61T00Datatype.getClavecat();

		sbValues.append(" VALUES ");
		sbValues.append("(");
		sbValues.append(this.getStringValues(P06B61_EV_NUMEXP));
		sbValues.append(",");
		sbValues.append(this.getStringValues(P06B61_EV_CIF));
		sbValues.append(",");
		sbValues.append(this.getStringValues(P06B61_EV_ENTIDAD));
		sbValues.append(",");
		sbValues.append(this.getStringValues(P06B61_EV_CALLE));
		sbValues.append(",");
		sbValues.append(this.getStringValues(P06B61_EV_PORTAL));
		sbValues.append(",");
		sbValues.append(this.getStringValues(P06B61_EV_PISO));
		sbValues.append(",");
		sbValues.append(this.getStringValues(P06B61_EV_LETRA));
		sbValues.append(",");
		if ("".equals(P06B61_EV_CODPRO)){
			sbValues.append("NULL");			
		}else{
			sbValues.append("TO_NUMBER(");			
			sbValues.append(P06B61_EV_CODPRO);
			sbValues.append(")");
		}
		sbValues.append(",");
		if ("".equals(P06B61_EV_CODMUN)){
			sbValues.append("NULL");			
		}else{
			sbValues.append("TO_NUMBER(");			
			sbValues.append(P06B61_EV_CODMUN);
			sbValues.append(")");
		}
		sbValues.append(",");
		if ("".equals(P06B61_EV_LOCALID)){
			sbValues.append("NULL");			
		}else{
			sbValues.append("TO_NUMBER(");			
			sbValues.append(P06B61_EV_LOCALID);
			sbValues.append(")");
		}
		sbValues.append(",");
		sbValues.append(this.getStringValues(P06B61_EV_CODPST));
		sbValues.append(",");
		sbValues.append(this.getStringValues(P06B61_EV_CLAVECAT));
		sbValues.append(")");
				
		this.sql =  altaTramitaguneSQL + " " + sbValues.toString();
	}
	
	/**
	 */
	private PreparedStatement prepareAlta71SQL(P06B61T00Datatype p06B61T00Datatype, P06B64T00Datatype p06B64T00Datatype) throws SQLException {

		StringBuilder alta71SQL = new StringBuilder();
		
		alta71SQL.append("INSERT INTO " + P06BTablas.P06B_P06B71T00_TABLA + " ("); 
		alta71SQL.append(P06BTablas.P06B_P06B71_EV_CORRELATENCPETIC); 
		alta71SQL.append(", ");
		alta71SQL.append(P06BTablas.P06B_P06B71_EV_NUMEXP); 
		alta71SQL.append(", ");
		alta71SQL.append(P06BTablas.P06B_P06B71_EV_CIF); 
		alta71SQL.append(", ");
		alta71SQL.append(P06BTablas.P06B_P06B71_EV_ENTIDAD); 
		alta71SQL.append(", ");
		alta71SQL.append(P06BTablas.P06B_P06B71_EV_CLAVECAT); 
		alta71SQL.append(", ");
		alta71SQL.append(P06BTablas.P06B_P06B71_EV_ALTABAJA); 
		alta71SQL.append(") VALUES (");
		alta71SQL.append("?");
		alta71SQL.append(", ?");
		alta71SQL.append(", ?");
		alta71SQL.append(", ?");
		alta71SQL.append(", ?");
		alta71SQL.append(", ?");
		alta71SQL.append(")");

		this.sql =  alta71SQL.toString();
		pstmt = con.prepareStatement(this.sql);
		
		pstmt.setInt(1, p06B64T00Datatype.getCorrelativo());
		pstmt.setString(2, p06B61T00Datatype.getExpedi());
		pstmt.setString(3, p06B61T00Datatype.getCif());
		pstmt.setString(4, p06B61T00Datatype.getEntidad());
		pstmt.setString(5, p06B61T00Datatype.getClavecat());
		pstmt.setByte(6, p06B61T00Datatype.getAltaBaja());

		return pstmt;		
	}
	
		
	
	
	/**
	 * Obtiene la SQL asociada al alta de una solicitud de reclamacin
	 * 
	 * @param solicitud
	 *            : Objeto de tipo AltaMediadores con los datos de negocio de la solicitud de reclamacin
	 *            a almacenar en base de datos
	 */
	private void getAlta60SQL(DatosMediadores mediador) {

		String altaTramitaguneSQL = "";
		
		altaTramitaguneSQL = "INSERT INTO P06B60T00_CAPACIDADFINANCIERA (P06B60_CF_NUMEXP,P06B60_CF_DECLARO,P06B60_CF_IMPFONDOS,P06B60_CF_IMPCAPACIDAD,P06B60_CF_CONTRATASEGURO,P06B60_CF_TEXTOSEGURO,P06B60_CF_CONTRATAAVAL,P06B60_CF_TEXTOAVAL)";

		StringBuilder sbValues = new StringBuilder("");
		String P06B60_CF_NUMEXP = "";
		String P06B60_CF_DECLARO = "";
		String P06B60_CF_IMPFONDOS = "";
		String P06B60_CF_IMPCAPACIDAD = "";
		String P06B60_CF_CONTRATASEGURO = "";
		String P06B60_CF_TEXTOSEGURO = "";
		String P06B60_CF_CONTRATAAVAL = "";
		String P06B60_CF_TEXTOAVAL = "";
//		P06B60_CF_NUMEXP = mediador.numExpediente();
		P06B60_CF_NUMEXP = mediador.formatearExpediente();
		P06B60_CF_DECLARO = ((Byte)(mediador.getcFDeclaro())).toString();
		if (mediador.getcFDeclaro()==1){
			P06B60_CF_IMPFONDOS = ((Float)mediador.getcFImpFondos()).toString();
			P06B60_CF_IMPCAPACIDAD = ((Float)mediador.getcFImpCapacidad()).toString();
			if (mediador.iscFContrataSeguro()){
				P06B60_CF_CONTRATASEGURO = "1";
				P06B60_CF_TEXTOSEGURO = mediador.getcFTextoSeguro();
			}else{
				P06B60_CF_CONTRATASEGURO = "0";
			}
			if (mediador.iscFContrataAval()){
				P06B60_CF_CONTRATAAVAL = "1";
				P06B60_CF_TEXTOAVAL = mediador.getcFTextoAval();			
			}else{
				P06B60_CF_CONTRATAAVAL = "0";
			}			
		}

		sbValues.append(" VALUES ");
		sbValues.append("(");
		sbValues.append(this.getStringValues(P06B60_CF_NUMEXP));
		sbValues.append(",");
		sbValues.append(P06B60_CF_DECLARO);
		sbValues.append(",");
		if (mediador.getcFDeclaro()==1){
			sbValues.append(P06B60_CF_IMPFONDOS);
			sbValues.append(",");
			sbValues.append(P06B60_CF_IMPCAPACIDAD);
			sbValues.append(",");
			sbValues.append(P06B60_CF_CONTRATASEGURO);
			sbValues.append(",");			
		}else{
			sbValues.append("NULL");
			sbValues.append(",");
			sbValues.append("NULL");
			sbValues.append(",");
			sbValues.append("NULL");
			sbValues.append(",");			
		}
		sbValues.append(this.getStringValues(P06B60_CF_TEXTOSEGURO));
		sbValues.append(",");
		if (mediador.getcFDeclaro()==1){
			sbValues.append(P06B60_CF_CONTRATAAVAL);
		}else{
			sbValues.append("NULL");
		}
		sbValues.append(",");
		if (mediador.getcFDeclaro()==1){
			sbValues.append(this.getStringValues(P06B60_CF_TEXTOAVAL));
		}else{
			sbValues.append("NULL");
		}
		sbValues.append(")");
				
		this.sql =  altaTramitaguneSQL + " " + sbValues.toString();
	}

	
	/**
	 */
	private PreparedStatement prepareAlta80SQL(DatosMediadores mediador, P06B64T00Datatype p06B64T00Datatype) throws SQLException {

		StringBuilder alta80SQL = new StringBuilder();
		
		alta80SQL.append("INSERT INTO " + P06BTablas.P06B_P06B80T00_TABLA + " ("); 
		alta80SQL.append(P06BTablas.P06B_P06B80_CF_CORRELATENCPETIC); 
		alta80SQL.append(", ");
		alta80SQL.append(P06BTablas.P06B_P06B80_CF_NUMEXP); 
		alta80SQL.append(", ");
		alta80SQL.append(P06BTablas.P06B_P06B80_CF_DECLARO); 
		if (mediador.getcFDeclaro()==P06BConstantes.P06B_CF_DEBECUMPLIMENTAR){
			alta80SQL.append(", ");
			alta80SQL.append(P06BTablas.P06B_P06B80_CF_IMPFONDOS); 
			alta80SQL.append(", ");
			alta80SQL.append(P06BTablas.P06B_P06B80_CF_IMPCAPACIDAD); 
			alta80SQL.append(", ");
			alta80SQL.append(P06BTablas.P06B_P06B80_CF_CONTRATASEGURO); 
			if (mediador.iscFContrataSeguro()){
				alta80SQL.append(", ");
				alta80SQL.append(P06BTablas.P06B_P06B80_CF_TEXTOSEGURO); 
			}			
			alta80SQL.append(", ");
			alta80SQL.append(P06BTablas.P06B_P06B80_CF_CONTRATAAVAL); 
			if (mediador.iscFContrataAval()){
				alta80SQL.append(", ");
				alta80SQL.append(P06BTablas.P06B_P06B80_CF_TEXTOAVAL); 
			}			
		}
		alta80SQL.append(") VALUES (");
		alta80SQL.append("?");
		alta80SQL.append(", ?");
		alta80SQL.append(", ?");
		if (mediador.getcFDeclaro()==1){
			alta80SQL.append(", ?");
			alta80SQL.append(", ?");
			alta80SQL.append(", ?");
			if (mediador.iscFContrataSeguro()){
				alta80SQL.append(", ?");				
			}
			alta80SQL.append(", ?");
			if (mediador.iscFContrataAval()){
				alta80SQL.append(", ?");				
			}			
		}
		alta80SQL.append(")");

		this.sql =  alta80SQL.toString();
		pstmt = con.prepareStatement(this.sql);
		
		int nDesfaseANumColTotal = 0;
		pstmt.setInt(1, p06B64T00Datatype.getCorrelativo());
		pstmt.setString(2, mediador.formatearExpediente());
		pstmt.setByte(3, mediador.getcFDeclaro());
		if (mediador.getcFDeclaro()==1){
			pstmt.setFloat(4, mediador.getcFImpFondos());
			pstmt.setFloat(5, mediador.getcFImpCapacidad());			
			pstmt.setInt(6, mediador.iscFContrataSeguro()?1:0);			
			if (mediador.iscFContrataSeguro()){
				pstmt.setString(7, mediador.getcFTextoSeguro());			
			}else{
				nDesfaseANumColTotal += 1;
			}
			pstmt.setInt(8-nDesfaseANumColTotal, mediador.iscFContrataAval()?1:0);			
			if (mediador.iscFContrataAval()){
				pstmt.setString(9-nDesfaseANumColTotal, mediador.getcFTextoAval());			
			}else{
				nDesfaseANumColTotal += 1;
			}
		}else{
			nDesfaseANumColTotal += 2;
		}

		return pstmt;		
	}
	
		
	/**
	 * Obtiene la SQL asociada al alta de una solicitud de reclamacin
	 * 
	 * @param solicitud
	 *            : Objeto de tipo SolicitudReclamacion con los datos de negocio de la solicitud de reclamacin
	 *            a almacenar en base de datos
	 */
	private void getInsertAdjuntosExpAltaSQL(DatosMediadores mediador, List<P06B81T00Datatype> listaDocumentos) {

		String altaTramitaguneAdjuntosSQL = "";
		String datosAdjuntosSQL = "";
		
		altaTramitaguneAdjuntosSQL = "INSERT INTO P06B81T00_DOCUMENTOSTRAMITAGUN (P06B81_DT_NUMEXP, P06B81_DT_CORRELATENCPETIC, P06B81_DT_ROLEIDPIDFICHERO, P06B81_DT_ROLENAMECASPIDFICHER, P06B81_DT_ROLENAMEEUSPIDFICHER, P06B81_DT_CODPIDFICHERO, P06B81_DT_NOMBREFICHERO, P06B81_DT_EXTENSIONFICHERO) ";
		
		Integer contExtFich=0;
		for(P06B81T00Datatype documento:listaDocumentos){
			if(!datosAdjuntosSQL.equals("")){
				datosAdjuntosSQL += " UNION ALL ";	
			}
			datosAdjuntosSQL += " select '" + mediador.formatearExpediente() + "',";
			datosAdjuntosSQL += documento.getCorrelAtencPet() + ",";
			datosAdjuntosSQL += "'" + documento.getRoleIdEnPid() + "',";
			datosAdjuntosSQL += "'" + documento.getRoleNameCasEnPid() + "',";
			datosAdjuntosSQL += "'" + documento.getRoleNameEusEnPid() + "',";
			datosAdjuntosSQL += "'" + documento.getReferenciaEnPid() + "',";
			datosAdjuntosSQL += "'" + documento.getNombreEnPid() + "',";
			if(documento.getExtensionEnPid()!=null){
				datosAdjuntosSQL += "'" + documento.getExtensionEnPid() + "'";
			}else{
				datosAdjuntosSQL += "NULL";
			}
			datosAdjuntosSQL += " from dual";
			contExtFich++;
		}
		
		this.sql =  altaTramitaguneAdjuntosSQL + datosAdjuntosSQL;
	}
	
	/**
	 * Obtiene la SQL asociada al alta de una solicitud de reclamacin
	 * 
	 * @param solicitud
	 *            : Objeto de tipo SolicitudReclamacion con los datos de negocio de la solicitud de reclamacin
	 *            a almacenar en base de datos
	 */
	private void getInsertAdjuntosExpCancelSQL(DatosMediadores mediador, List<P06B81T00Datatype> listaDocumentos) {

		String altaTramitaguneAdjuntosSQL = "";
		String datosAdjuntosSQL = "";
		
		altaTramitaguneAdjuntosSQL = "INSERT INTO P06B81T00_DOCUMENTOSTRAMITAGUN (P06B81_DT_NUMEXP, P06B81_DT_CORRELATENCPETIC, P06B81_DT_ROLEIDPIDFICHERO, P06B81_DT_ROLENAMECASPIDFICHER, P06B81_DT_ROLENAMEEUSPIDFICHER, P06B81_DT_CODPIDFICHERO, P06B81_DT_NOMBREFICHERO, P06B81_DT_EXTENSIONFICHERO) ";
		
		Integer contExtFich=0;
		for(P06B81T00Datatype documento:listaDocumentos){
			if(!datosAdjuntosSQL.equals("")){
				datosAdjuntosSQL += " UNION ALL ";	
			}
			datosAdjuntosSQL += " select '" + mediador.getExpedienteFormateado() + "',";
			datosAdjuntosSQL += documento.getCorrelAtencPet() + ",";
			datosAdjuntosSQL += "'" + documento.getRoleIdEnPid() + "',";
			datosAdjuntosSQL += "'" + documento.getRoleNameCasEnPid() + "',";
			datosAdjuntosSQL += "'" + documento.getRoleNameEusEnPid() + "',";
			datosAdjuntosSQL += "'" + documento.getReferenciaEnPid() + "',";
			datosAdjuntosSQL += "'" + documento.getNombreEnPid() + "',";
			if(documento.getExtensionEnPid()!=null){
				datosAdjuntosSQL += "'" + documento.getExtensionEnPid() + "'";
			}else{
				datosAdjuntosSQL += "NULL";
			}
			datosAdjuntosSQL += " from dual";
			contExtFich++;
		}
		
		this.sql =  altaTramitaguneAdjuntosSQL + datosAdjuntosSQL;
	}
	
	/**
	 * Obtiene la SQL asociada al alta de una solicitud de reclamacin
	 * 
	 * @param solicitud
	 *            : Objeto de tipo SolicitudReclamacion con los datos de negocio de la solicitud de reclamacin
	 *            a almacenar en base de datos
	 */
	private void getInsertAdjuntosAPSQL(DatosMediadores mediador, P06B64T00Datatype p06B64T00Datatype, List<P06B82T00Datatype> listaDocumentos) {

		String altaTramitaguneAdjuntosSQL = "";
		String datosAdjuntosSQL = "";
		
		altaTramitaguneAdjuntosSQL = "INSERT INTO P06B82T00_DOCUMENTOSMODTRAMITA (P06B82_DM_CORRELATENCPETIC, P06B82_DM_ROLEIDPIDFICHERO, P06B82_DM_ROLENAMECASPIDFICHER, P06B82_DM_ROLENAMEEUSPIDFICHER, P06B82_DM_CODPIDFICHERO, P06B82_DM_NOMBREFICHERO, P06B82_DM_EXTENSIONFICHERO) ";
		
		Integer contExtFich=0;
		for(P06B82T00Datatype documento:listaDocumentos){
			if(!datosAdjuntosSQL.equals("")){
				datosAdjuntosSQL += " UNION ALL ";	
			}
			datosAdjuntosSQL += " select " + p06B64T00Datatype.getCorrelativo() + ",";
			datosAdjuntosSQL += "'" + documento.getRoleIdEnPid() + "',";
			datosAdjuntosSQL += "'" + documento.getRoleNameCasEnPid() + "',";
			datosAdjuntosSQL += "'" + documento.getRoleNameEusEnPid() + "',";
			datosAdjuntosSQL += "'" + documento.getReferenciaEnPid() + "',";
			datosAdjuntosSQL += "'" + documento.getNombreEnPid() + "',";
			if(documento.getExtensionEnPid()!=null){
				datosAdjuntosSQL += "'" + documento.getExtensionEnPid() + "'";
			}else{
				datosAdjuntosSQL += "NULL";
			}
			datosAdjuntosSQL += " from dual";
			contExtFich++;
		}
		
		this.sql =  altaTramitaguneAdjuntosSQL + datosAdjuntosSQL;
	}
	
	/**
	 * Obtiene la SQL asociada a la obtencin del mayor cdigo de solicitud
	 * almacenado en base de datos
	 * 
	 */
	private void getCodRclteCIFSQL(String sCIF) {

		String cododRclteCIFSQL = "";

		cododRclteCIFSQL = "SELECT CODRECLTE_F1 FROM R76F1T00 WHERE NIF_F1 = '" + sCIF + "'";

		this.sql = cododRclteCIFSQL;
	}
	
	/**
	 * Obtengo el cdigo del Reclamante de solicitud de alta de plan de previsin
	 * 
	 * @return Devuelve un objeto int con el cdigo de Reclamante. Si hay mas de un reclamante con el mismo CIF devuelve un cero.
	 * 
	 * @throws Exception
	 *             : Lanza un objeto de tipo Exception en caso de haber existido
	 *             algn problema
	 */
	public int obtenerCodRclteCIF(String sCIF) throws Exception {

		int codRclte = 0;

		try {
			stmt = con.createStatement();

			this.getCodRclteCIFSQL(sCIF);

			P06BLog.send(0,P06bMng.class, "(obtenerCodRclteCIF) Consulta a ejecutar: "
					+ this.sql);

			rs = stmt.executeQuery(this.sql);

			P06BLog.send(0,P06bMng.class, "(obtenerCodRclteCIF) Consulta correctamente ejecutada");

			int n=0;
			while (rs.next()) {
				n++;
				codRclte = rs.getInt(1);
			}
			if (n>1){
				//Hay mas de un reclamante con el mismo DNI. la seleccion del Reclamante la deber hacer el usuario del TEAE
				codRclte =-1;
			}

		} catch (Exception e) {
			P06BLog.send(0,P06bMng.class, "(obtenerCodRclteCIF) Error al ejecutar la consulta");
			throw e;
		} finally {
			if (this.rs != null) {
				this.rs.close();
			}
			if (this.stmt != null) {
				this.stmt.close();
			}
		}
		return codRclte;
	}
	
	/**
	 * Obtiene una cadena de caracteres con el formato necesario para ser
	 * introducida en base de datos
	 * 
	 * @param value
	 *            :Objeto de tipo String con el valor a introducir en base de
	 *            datos
	 * 
	 * @return Devuelve un objeto String con la cadena de caracteres con el
	 *         formato necesario para ser introducida en base de datos
	 */
	private String getStringValues(String value) {
		String stringValue = "";

		if (value != null && !value.equals("")) {
			stringValue = "'" + value + "'";
		} else {
			stringValue = "NULL";
		}

		return stringValue;
	}

}
